/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.configuration.IConfiguration;
import gov.nist.secauto.metaschema.core.model.IAssemblyDefinition;
import gov.nist.secauto.metaschema.core.model.IDefinition;
import gov.nist.secauto.metaschema.core.model.IModule;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.schemagen.AbstractSchemaGenerator;
import gov.nist.secauto.metaschema.schemagen.SchemaGenerationException;
import gov.nist.secauto.metaschema.schemagen.SchemaGenerationFeature;
import gov.nist.secauto.metaschema.schemagen.json.IDefineableJsonSchema;
import gov.nist.secauto.metaschema.schemagen.json.IDefinitionJsonSchema;
import gov.nist.secauto.metaschema.schemagen.json.impl.JsonDatatypeManager;
import gov.nist.secauto.metaschema.schemagen.json.impl.JsonGenerationState;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class JsonSchemaGenerator
extends AbstractSchemaGenerator<JsonGenerator, JsonDatatypeManager, JsonGenerationState> {
    @NonNull
    private final JsonFactory jsonFactory;

    public JsonSchemaGenerator() {
        this(new JsonFactory());
    }

    public JsonSchemaGenerator(@NonNull JsonFactory jsonFactory) {
        this.jsonFactory = jsonFactory;
    }

    @NonNull
    public JsonFactory getJsonFactory() {
        return this.jsonFactory;
    }

    @Override
    protected JsonGenerator newWriter(Writer out) {
        try {
            return (JsonGenerator)ObjectUtils.notNull((Object)this.getJsonFactory().createGenerator(out).setCodec((ObjectCodec)new ObjectMapper()).useDefaultPrettyPrinter().disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET));
        }
        catch (IOException ex) {
            throw new SchemaGenerationException(ex);
        }
    }

    @Override
    protected JsonGenerationState newGenerationState(IModule module, JsonGenerator schemaWriter, IConfiguration<SchemaGenerationFeature<?>> configuration) {
        return new JsonGenerationState(module, schemaWriter, configuration);
    }

    @Override
    protected void generateSchema(JsonGenerationState state) {
        IModule module = state.getModule();
        try {
            List rootAssemblyDefinitions;
            state.writeStartObject();
            state.writeField("$schema", "http://json-schema.org/draft-07/schema#");
            state.writeField("$id", String.format("%s/%s-%s-schema.json", module.getXmlNamespace(), module.getShortName(), module.getVersion()));
            state.writeField("$comment", module.getName().toMarkdown());
            state.writeField("type", "object");
            ObjectNode definitionsObject = state.generateDefinitions();
            if (!definitionsObject.isEmpty()) {
                state.writeField("definitions", definitionsObject);
            }
            if ((rootAssemblyDefinitions = state.getMetaschemaIndex().getDefinitions().stream().map(entry -> entry.getDefinition()).filter(definition -> definition instanceof IAssemblyDefinition && ((IAssemblyDefinition)definition).isRoot()).map(definition -> (IAssemblyDefinition)definition).collect(Collectors.toUnmodifiableList())).isEmpty()) {
                throw new SchemaGenerationException("No root definitions found");
            }
            List rootEntries = rootAssemblyDefinitions.stream().map(root -> {
                assert (root != null);
                return new RootPropertyEntry((IAssemblyDefinition)root, state);
            }).collect(Collectors.toUnmodifiableList());
            JsonGenerator writer = (JsonGenerator)state.getWriter();
            if (rootEntries.size() == 1) {
                ((RootPropertyEntry)rootEntries.iterator().next()).write(writer);
            } else {
                writer.writeFieldName("oneOf");
                writer.writeStartArray();
                for (RootPropertyEntry root2 : rootEntries) {
                    assert (root2 != null);
                    writer.writeStartObject();
                    root2.write(writer);
                    writer.writeEndObject();
                }
                writer.writeEndArray();
            }
            state.writeEndObject();
        }
        catch (IOException ex) {
            throw new SchemaGenerationException(ex);
        }
    }

    @NonNull
    private static Map<String, ObjectNode> generateRootProperties(@NonNull IAssemblyDefinition definition, @NonNull JsonGenerationState state) {
        LinkedHashMap<String, ObjectNode> properties = new LinkedHashMap<String, ObjectNode>();
        properties.put("$schema", JsonNodeFactory.instance.objectNode().put("type", "string").put("format", "uri-reference"));
        ObjectNode rootObj = (ObjectNode)ObjectUtils.notNull((Object)JsonNodeFactory.instance.objectNode());
        IDefinitionJsonSchema schema = state.getSchema(IDefineableJsonSchema.IKey.of((IDefinition)definition));
        schema.generateSchemaOrRef(rootObj, state);
        properties.put(definition.getRootJsonName(), rootObj);
        return properties;
    }

    private static class RootPropertyEntry {
        @NonNull
        private final IAssemblyDefinition definition;
        @NonNull
        private final Map<String, ObjectNode> properties;

        public RootPropertyEntry(@NonNull IAssemblyDefinition definition, @NonNull JsonGenerationState state) {
            this.definition = definition;
            this.properties = JsonSchemaGenerator.generateRootProperties(definition, state);
        }

        @NonNull
        protected IAssemblyDefinition getDefinition() {
            return this.definition;
        }

        @NonNull
        protected Map<String, ObjectNode> getProperties() {
            return this.properties;
        }

        public void write(JsonGenerator writer) throws IOException {
            writer.writeFieldName("properties");
            writer.writeStartObject();
            for (Map.Entry<String, ObjectNode> entry : this.getProperties().entrySet()) {
                writer.writeFieldName(entry.getKey());
                writer.writeTree((TreeNode)entry.getValue());
            }
            writer.writeEndObject();
            writer.writeFieldName("required");
            writer.writeStartArray();
            writer.writeString(this.getDefinition().getRootJsonName());
            writer.writeEndArray();
            writer.writeBooleanField("additionalProperties", false);
        }
    }
}

