/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen.json.impl;

import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.model.IDefinition;
import gov.nist.secauto.metaschema.core.model.INamedModelElement;
import gov.nist.secauto.metaschema.schemagen.SchemaGenerationException;
import gov.nist.secauto.metaschema.schemagen.json.IDefineableJsonSchema;
import gov.nist.secauto.metaschema.schemagen.json.IDefinitionJsonSchema;
import gov.nist.secauto.metaschema.schemagen.json.IJsonGenerationState;
import gov.nist.secauto.metaschema.schemagen.json.impl.AbstractDefineableJsonSchema;
import gov.nist.secauto.metaschema.schemagen.json.impl.MetadataUtils;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;

public abstract class AbstractDefinitionJsonSchema<D extends IDefinition>
extends AbstractDefineableJsonSchema
implements IDefinitionJsonSchema<D> {
    @NonNull
    private final D definition;

    @Override
    public D getDefinition() {
        return this.definition;
    }

    protected AbstractDefinitionJsonSchema(@NonNull D definition) {
        this.definition = definition;
    }

    @Override
    public boolean isInline(IJsonGenerationState state) {
        return state.isInline((IDefinition)this.getDefinition());
    }

    protected abstract void generateBody(@NonNull IJsonGenerationState var1, @NonNull ObjectNode var2) throws IOException;

    @Override
    public void generateInlineSchema(ObjectNode obj, IJsonGenerationState state) {
        D definition = this.getDefinition();
        try {
            AbstractDefinitionJsonSchema.generateTitle(definition, obj);
            AbstractDefinitionJsonSchema.generateDescription(definition, obj);
            this.generateBody(state, obj);
        }
        catch (IOException ex) {
            throw new SchemaGenerationException(ex);
        }
    }

    public static void generateTitle(@NonNull IDefinition definition, @NonNull ObjectNode obj) {
        MetadataUtils.generateTitle((INamedModelElement)definition, obj);
    }

    public static void generateDescription(@NonNull IDefinition definition, @NonNull ObjectNode obj) {
        MetadataUtils.generateDescription(definition, obj);
    }

    @Override
    public void gatherDefinitions(@NonNull Map<IDefineableJsonSchema.IKey, IDefinitionJsonSchema<?>> gatheredDefinitions, @NonNull IJsonGenerationState state) {
        gatheredDefinitions.put(this.getKey(), this);
    }

    public static class SimpleKey
    implements IDefineableJsonSchema.IKey {
        @NonNull
        private final IDefinition definition;

        public SimpleKey(@NonNull IDefinition definition) {
            this.definition = definition;
        }

        @Override
        public IDefinition getDefinition() {
            return this.definition;
        }

        @Override
        public String getJsonKeyFlagName() {
            return null;
        }

        @Override
        public String getDiscriminatorProperty() {
            return null;
        }

        @Override
        public String getDiscriminatorValue() {
            return null;
        }

        public int hashCode() {
            return Objects.hash(this.definition, null, null, null);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof IDefineableJsonSchema.IKey)) {
                return false;
            }
            IDefineableJsonSchema.IKey other = (IDefineableJsonSchema.IKey)obj;
            return Objects.equals(this.definition, other.getDefinition()) && Objects.equals(null, other.getJsonKeyFlagName()) && Objects.equals(null, other.getDiscriminatorProperty()) && Objects.equals(null, other.getDiscriminatorValue());
        }
    }
}

