/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen.json.impl;

import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.model.IInstance;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.schemagen.json.IJsonGenerationState;
import gov.nist.secauto.metaschema.schemagen.json.impl.IJsonProperty;

public abstract class AbstractJsonProperty<I extends IInstance>
implements IJsonProperty<I> {
    @NonNull
    private final I instance;

    protected AbstractJsonProperty(@NonNull I instance) {
        this.instance = instance;
    }

    @Override
    @NonNull
    public I getInstance() {
        return this.instance;
    }

    protected void generateMetadata(@NonNull ObjectNode obj) {
    }

    protected abstract void generateBody(@NonNull ObjectNode var1, @NonNull IJsonGenerationState var2);

    @Override
    public void generateProperty(IJsonProperty.PropertyCollection properties, IJsonGenerationState state) {
        ObjectNode contextObj = (ObjectNode)ObjectUtils.notNull((Object)state.getJsonNodeFactory().objectNode());
        this.generateMetadata(contextObj);
        this.generateBody(contextObj, state);
        String name = this.getName();
        properties.addProperty(name, contextObj);
        if (this.isRequired()) {
            properties.addRequired(name);
        }
    }
}

