/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen.json.impl;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import gov.nist.secauto.metaschema.core.model.IDefinition;
import gov.nist.secauto.metaschema.core.model.IFlagInstance;
import gov.nist.secauto.metaschema.core.model.IModelDefinition;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.schemagen.IGenerationState;
import gov.nist.secauto.metaschema.schemagen.json.IDefineableJsonSchema;
import gov.nist.secauto.metaschema.schemagen.json.IDefinitionJsonSchema;
import gov.nist.secauto.metaschema.schemagen.json.IJsonGenerationState;
import gov.nist.secauto.metaschema.schemagen.json.impl.AbstractDefinitionJsonSchema;
import gov.nist.secauto.metaschema.schemagen.json.impl.FlagInstanceJsonProperty;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class AbstractModelDefinitionJsonSchema<D extends IModelDefinition>
extends AbstractDefinitionJsonSchema<D> {
    @Nullable
    private final String jsonKeyFlagName;
    @Nullable
    private final String discriminatorProperty;
    @Nullable
    private final String discriminatorValue;
    @NonNull
    private final List<FlagInstanceJsonProperty> flagProperties;
    @NonNull
    private final IDefineableJsonSchema.IKey key;

    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"}, justification="Use of final fields")
    protected AbstractModelDefinitionJsonSchema(@NonNull D definition, @Nullable String jsonKeyFlagName, @Nullable String discriminatorProperty, @Nullable String discriminatorValue) {
        super(definition);
        this.jsonKeyFlagName = jsonKeyFlagName;
        this.discriminatorProperty = discriminatorProperty;
        this.discriminatorValue = discriminatorValue;
        this.key = IDefineableJsonSchema.IKey.of(definition, jsonKeyFlagName, discriminatorProperty, discriminatorValue);
        Stream<Object> flagStream = definition.getFlagInstances().stream();
        if (jsonKeyFlagName != null) {
            IFlagInstance jsonKeyFlag = definition.getFlagInstanceByName(definition.getContainingModule().toFlagQName(jsonKeyFlagName));
            if (jsonKeyFlag == null) {
                throw new IllegalArgumentException(String.format("The referenced json-key flag-name '%s' does not exist on definition '%s'.", jsonKeyFlagName, definition.getName()));
            }
            flagStream = flagStream.filter(instance -> instance != jsonKeyFlag);
        }
        this.flagProperties = (List)ObjectUtils.notNull(flagStream.map(instance -> new FlagInstanceJsonProperty((IFlagInstance)ObjectUtils.requireNonNull((Object)instance))).collect(Collectors.toUnmodifiableList()));
    }

    @Override
    public IDefineableJsonSchema.IKey getKey() {
        return this.key;
    }

    protected String getJsonKeyFlagName() {
        return this.jsonKeyFlagName;
    }

    protected String getDiscriminatorProperty() {
        return this.discriminatorProperty;
    }

    protected String getDiscriminatorValue() {
        return this.discriminatorValue;
    }

    @Override
    protected String generateDefinitionName(IJsonGenerationState state) {
        IModelDefinition definition = (IModelDefinition)this.getDefinition();
        StringBuilder builder = new StringBuilder();
        if (this.jsonKeyFlagName != null) {
            builder.append(IGenerationState.toCamelCase(this.jsonKeyFlagName)).append("JsonKey");
        }
        if (this.discriminatorProperty != null || this.discriminatorValue != null) {
            builder.append(IGenerationState.toCamelCase((String)ObjectUtils.requireNonNull((Object)this.discriminatorProperty))).append(IGenerationState.toCamelCase((String)ObjectUtils.requireNonNull((Object)this.discriminatorValue))).append("Choice");
        }
        return state.getTypeNameForDefinition((IDefinition)definition, builder.toString());
    }

    protected List<FlagInstanceJsonProperty> getFlagProperties() {
        return this.flagProperties;
    }

    @Override
    public void gatherDefinitions(@NonNull Map<IDefineableJsonSchema.IKey, IDefinitionJsonSchema<?>> gatheredDefinitions, @NonNull IJsonGenerationState state) {
        super.gatherDefinitions(gatheredDefinitions, state);
        for (FlagInstanceJsonProperty property : this.getFlagProperties()) {
            property.gatherDefinitions(gatheredDefinitions, state);
        }
    }

    public static class ComplexKey
    implements IDefineableJsonSchema.IKey {
        @NonNull
        private final IDefinition definition;
        @Nullable
        private final String jsonKeyFlagName;
        @Nullable
        private final String discriminatorProperty;
        @Nullable
        private final String discriminatorValue;

        public ComplexKey(@NonNull IDefinition definition, @Nullable String jsonKeyFlagName, @Nullable String discriminatorProperty, @Nullable String discriminatorValue) {
            this.definition = definition;
            this.jsonKeyFlagName = jsonKeyFlagName;
            this.discriminatorProperty = discriminatorProperty;
            this.discriminatorValue = discriminatorValue;
        }

        @Override
        @NonNull
        public IDefinition getDefinition() {
            return this.definition;
        }

        @Override
        @Nullable
        public String getJsonKeyFlagName() {
            return this.jsonKeyFlagName;
        }

        @Override
        public String getDiscriminatorProperty() {
            return this.discriminatorProperty;
        }

        @Override
        public String getDiscriminatorValue() {
            return this.discriminatorValue;
        }

        public int hashCode() {
            return Objects.hash(this.definition, this.jsonKeyFlagName, this.discriminatorProperty, this.discriminatorValue);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof IDefineableJsonSchema.IKey)) {
                return false;
            }
            IDefineableJsonSchema.IKey other = (IDefineableJsonSchema.IKey)obj;
            return Objects.equals(this.definition, other.getDefinition()) && Objects.equals(this.jsonKeyFlagName, other.getJsonKeyFlagName()) && Objects.equals(this.discriminatorProperty, other.getDiscriminatorProperty()) && Objects.equals(this.discriminatorValue, other.getDiscriminatorValue());
        }
    }
}

