/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen.json.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.core.model.IAssemblyDefinition;
import gov.nist.secauto.metaschema.core.model.IChoiceGroupInstance;
import gov.nist.secauto.metaschema.core.model.IChoiceInstance;
import gov.nist.secauto.metaschema.core.model.INamedModelInstanceAbsolute;
import gov.nist.secauto.metaschema.core.model.ModelType;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.schemagen.json.IDefineableJsonSchema;
import gov.nist.secauto.metaschema.schemagen.json.IDefinitionJsonSchema;
import gov.nist.secauto.metaschema.schemagen.json.IJsonGenerationState;
import gov.nist.secauto.metaschema.schemagen.json.impl.AbstractJsonProperty;
import gov.nist.secauto.metaschema.schemagen.json.impl.AbstractModelDefinitionJsonSchema;
import gov.nist.secauto.metaschema.schemagen.json.impl.ChoiceGroupInstanceJsonProperty;
import gov.nist.secauto.metaschema.schemagen.json.impl.FlagInstanceJsonProperty;
import gov.nist.secauto.metaschema.schemagen.json.impl.IGroupableModelInstanceJsonProperty;
import gov.nist.secauto.metaschema.schemagen.json.impl.IJsonProperty;
import gov.nist.secauto.metaschema.schemagen.json.impl.NamedModelInstanceJsonProperty;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nl.talsmasoftware.lazy4j.Lazy;

public class AssemblyDefinitionJsonSchema
extends AbstractModelDefinitionJsonSchema<IAssemblyDefinition> {
    private final Lazy<List<IGroupableModelInstanceJsonProperty<?>>> groupableModelInstances = Lazy.lazy(() -> (List)ObjectUtils.notNull(definition.getModelInstances().stream().filter(instance -> !(instance instanceof IChoiceInstance)).map(instance -> {
        AbstractJsonProperty property;
        if (instance instanceof INamedModelInstanceAbsolute) {
            INamedModelInstanceAbsolute named = (INamedModelInstanceAbsolute)instance;
            property = new NamedModelInstanceJsonProperty(named, state);
        } else if (instance instanceof IChoiceGroupInstance) {
            IChoiceGroupInstance choice = (IChoiceGroupInstance)instance;
            property = new ChoiceGroupInstanceJsonProperty(choice, state);
        } else {
            throw new UnsupportedOperationException("model instance class not supported: " + instance.getClass().getName());
        }
        return property;
    }).collect(Collectors.toUnmodifiableList())));
    private final Map<INamedModelInstanceAbsolute, IGroupableModelInstanceJsonProperty<?>> choiceInstances;

    public AssemblyDefinitionJsonSchema(@NonNull IAssemblyDefinition definition, @Nullable String jsonKeyFlagName, @Nullable String discriminatorProperty, @Nullable String discriminatorValue, @NonNull IJsonGenerationState state) {
        super(definition, jsonKeyFlagName, discriminatorProperty, discriminatorValue);
        this.choiceInstances = definition.getChoiceInstances().stream().flatMap(choice -> AssemblyDefinitionJsonSchema.explodeChoice((IChoiceInstance)ObjectUtils.requireNonNull((Object)choice))).collect(Collectors.toUnmodifiableMap(Function.identity(), instance -> new NamedModelInstanceJsonProperty((INamedModelInstanceAbsolute)ObjectUtils.requireNonNull((Object)instance), state)));
    }

    private static Stream<? extends INamedModelInstanceAbsolute> explodeChoice(@NonNull IChoiceInstance choice) {
        return choice.getNamedModelInstances().stream();
    }

    @NonNull
    protected List<IGroupableModelInstanceJsonProperty<?>> getGroupableModelInstances() {
        return (List)this.groupableModelInstances.get();
    }

    @Override
    public void gatherDefinitions(@NonNull Map<IDefineableJsonSchema.IKey, IDefinitionJsonSchema<?>> gatheredDefinitions, @NonNull IJsonGenerationState state) {
        if (!gatheredDefinitions.containsKey(this.getKey())) {
            super.gatherDefinitions(gatheredDefinitions, state);
            for (IGroupableModelInstanceJsonProperty<?> property2 : this.getGroupableModelInstances()) {
                property2.gatherDefinitions(gatheredDefinitions, state);
            }
            this.choiceInstances.values().forEach(property -> property.gatherDefinitions(gatheredDefinitions, state));
        }
    }

    @Override
    protected void generateBody(IJsonGenerationState state, ObjectNode obj) throws IOException {
        obj.put("type", "object");
        IJsonProperty.PropertyCollection properties = new IJsonProperty.PropertyCollection();
        String discriminatorProperty = this.getDiscriminatorProperty();
        if (discriminatorProperty != null) {
            ObjectNode discriminatorObj = state.getJsonNodeFactory().objectNode();
            discriminatorObj.put("const", this.getDiscriminatorValue());
            properties.addProperty(discriminatorProperty, discriminatorObj);
        }
        for (FlagInstanceJsonProperty flagInstanceJsonProperty : this.getFlagProperties()) {
            assert (flagInstanceJsonProperty != null);
            flagInstanceJsonProperty.generateProperty(properties, state);
        }
        for (IGroupableModelInstanceJsonProperty iGroupableModelInstanceJsonProperty : this.getGroupableModelInstances()) {
            assert (iGroupableModelInstanceJsonProperty != null);
            iGroupableModelInstanceJsonProperty.generateProperty(properties, state);
        }
        List choices = ((IAssemblyDefinition)this.getDefinition()).getChoiceInstances();
        if (choices.isEmpty()) {
            properties.generate(obj);
            obj.put("additionalProperties", false);
        } else {
            List list = CollectionUtil.singletonList((Object)properties);
            List<IJsonProperty.PropertyCollection> list2 = this.explodeChoices(choices, list, state);
            if (list2.size() == 1) {
                list2.iterator().next().generate(obj);
            } else if (list2.size() > 1) {
                this.generateChoices(list2, obj, state);
            }
        }
    }

    protected void generateChoices(List<IJsonProperty.PropertyCollection> propertyChoices, @NonNull ObjectNode definitionNode, @NonNull IJsonGenerationState state) {
        ArrayNode anyOfdNode = (ArrayNode)ObjectUtils.notNull((Object)JsonNodeFactory.instance.arrayNode());
        for (IJsonProperty.PropertyCollection propertyChoice : propertyChoices) {
            ObjectNode choiceDefinitionNode = (ObjectNode)ObjectUtils.notNull((Object)JsonNodeFactory.instance.objectNode());
            propertyChoice.generate(choiceDefinitionNode);
            choiceDefinitionNode.put("additionalProperties", false);
            anyOfdNode.add((JsonNode)choiceDefinitionNode);
        }
        definitionNode.set("anyOf", (JsonNode)anyOfdNode);
    }

    protected List<IJsonProperty.PropertyCollection> explodeChoices(@NonNull Collection<? extends IChoiceInstance> choices, @NonNull List<IJsonProperty.PropertyCollection> propertyChoices, @NonNull IJsonGenerationState state) throws IOException {
        List<IJsonProperty.PropertyCollection> retval = propertyChoices;
        for (IChoiceInstance iChoiceInstance : choices) {
            LinkedList<IJsonProperty.PropertyCollection> newRetval = new LinkedList<IJsonProperty.PropertyCollection>();
            for (INamedModelInstanceAbsolute optionInstance : iChoiceInstance.getNamedModelInstances()) {
                if (ModelType.CHOICE.equals((Object)optionInstance.getModelType())) {
                    newRetval.addAll(this.explodeChoices(CollectionUtil.singleton((Object)((IChoiceInstance)optionInstance)), retval, state));
                    continue;
                }
                for (IJsonProperty.PropertyCollection oldInstanceProperties : retval) {
                    IJsonProperty.PropertyCollection newInstanceProperties = oldInstanceProperties.copy();
                    this.choiceInstances.get(optionInstance).generateProperty(newInstanceProperties, state);
                    newRetval.add(newInstanceProperties);
                }
            }
            retval = newRetval;
        }
        return retval;
    }
}

