/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen.json.impl;

import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import gov.nist.secauto.metaschema.core.model.IChoiceGroupInstance;
import gov.nist.secauto.metaschema.core.model.IGroupable;
import gov.nist.secauto.metaschema.core.model.INamedModelInstanceGrouped;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.schemagen.json.IDefineableJsonSchema;
import gov.nist.secauto.metaschema.schemagen.json.IDefinitionJsonSchema;
import gov.nist.secauto.metaschema.schemagen.json.IJsonGenerationState;
import gov.nist.secauto.metaschema.schemagen.json.impl.AbstractJsonProperty;
import gov.nist.secauto.metaschema.schemagen.json.impl.IGroupableModelInstanceJsonProperty;
import gov.nist.secauto.metaschema.schemagen.json.impl.builder.IModelInstanceBuilder;
import java.util.Map;

public class ChoiceGroupInstanceJsonProperty
extends AbstractJsonProperty<IChoiceGroupInstance>
implements IGroupableModelInstanceJsonProperty<IChoiceGroupInstance> {
    private final IModelInstanceBuilder<?> collectionBuilder;

    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"}, justification="Use of final fields")
    public ChoiceGroupInstanceJsonProperty(@NonNull IChoiceGroupInstance instance, @NonNull IJsonGenerationState state) {
        super(instance);
        this.collectionBuilder = IModelInstanceBuilder.newCollectionBuilder((IGroupable)instance);
        for (INamedModelInstanceGrouped groupedInstance : instance.getNamedModelInstances()) {
            assert (groupedInstance != null);
            this.collectionBuilder.addItemType(groupedInstance);
        }
    }

    protected IModelInstanceBuilder<?> getCollectionBuilder() {
        return this.collectionBuilder;
    }

    @Override
    public String getName() {
        return (String)ObjectUtils.requireNonNull((Object)((IChoiceGroupInstance)this.getInstance()).getGroupAsName());
    }

    @Override
    protected void generateBody(ObjectNode obj, IJsonGenerationState state) {
        this.getCollectionBuilder().build(obj, state);
    }

    @Override
    public void gatherDefinitions(@NonNull Map<IDefineableJsonSchema.IKey, IDefinitionJsonSchema<?>> gatheredDefinitions, @NonNull IJsonGenerationState state) {
        for (IModelInstanceBuilder.IType type : this.collectionBuilder.getTypes()) {
            type.gatherDefinitions(gatheredDefinitions, state);
        }
    }
}

