/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen.json.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.datatype.IDataTypeAdapter;
import gov.nist.secauto.metaschema.core.model.IDefinition;
import gov.nist.secauto.metaschema.core.model.IValuedDefinition;
import gov.nist.secauto.metaschema.core.model.constraint.IAllowedValue;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.schemagen.AbstractGenerationState;
import gov.nist.secauto.metaschema.schemagen.json.IDataTypeJsonSchema;
import gov.nist.secauto.metaschema.schemagen.json.IDefineableJsonSchema;
import gov.nist.secauto.metaschema.schemagen.json.IDefinitionJsonSchema;
import gov.nist.secauto.metaschema.schemagen.json.IJsonGenerationState;
import gov.nist.secauto.metaschema.schemagen.json.impl.AbstractDefineableJsonSchema;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.Map;

public class DataTypeRestrictionDefinitionJsonSchema
extends AbstractDefineableJsonSchema
implements IDataTypeJsonSchema,
IDefinitionJsonSchema<IValuedDefinition> {
    @NonNull
    private final IValuedDefinition definition;
    @NonNull
    private final AbstractGenerationState.AllowedValueCollection allowedValuesCollection;

    public DataTypeRestrictionDefinitionJsonSchema(@NonNull IValuedDefinition definition, @NonNull AbstractGenerationState.AllowedValueCollection allowedValuesCollection) {
        this.definition = definition;
        CollectionUtil.requireNonEmpty(allowedValuesCollection.getValues());
        this.allowedValuesCollection = allowedValuesCollection;
    }

    @Override
    public IDefineableJsonSchema.IKey getKey() {
        return IDefineableJsonSchema.IKey.of((IDefinition)this.definition, null, null, null);
    }

    @Override
    @NonNull
    public IValuedDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public IDataTypeAdapter<?> getDataTypeAdapter() {
        return this.getDefinition().getJavaTypeAdapter();
    }

    @NonNull
    protected AbstractGenerationState.AllowedValueCollection getAllowedValuesCollection() {
        return this.allowedValuesCollection;
    }

    @Override
    public boolean isInline(IJsonGenerationState state) {
        return true;
    }

    @Override
    protected String generateDefinitionName(IJsonGenerationState state) {
        return state.getTypeNameForDefinition((IDefinition)this.definition, "Value");
    }

    @Override
    public void generateInlineSchema(ObjectNode obj, IJsonGenerationState state) {
        ArrayNode enumArray = JsonNodeFactory.instance.arrayNode();
        AbstractGenerationState.AllowedValueCollection allowedValuesCollection = this.getAllowedValuesCollection();
        block6: for (IAllowedValue allowedValue : allowedValuesCollection.getValues()) {
            switch (this.getDefinition().getJavaTypeAdapter().getJsonRawType()) {
                case STRING: {
                    enumArray.add(allowedValue.getValue());
                    continue block6;
                }
                case BOOLEAN: {
                    enumArray.add(Boolean.parseBoolean(allowedValue.getValue()));
                    continue block6;
                }
                case INTEGER: {
                    enumArray.add(new BigInteger(allowedValue.getValue()));
                    continue block6;
                }
                case NUMBER: {
                    enumArray.add(new BigDecimal(allowedValue.getValue(), MathContext.DECIMAL64));
                    continue block6;
                }
            }
            throw new UnsupportedOperationException(this.getDefinition().getJavaTypeAdapter().getJsonRawType().toString());
        }
        IDataTypeJsonSchema dataTypeSchema = state.getSchema(this.getDefinition().getJavaTypeAdapter());
        ArrayNode ofArray = allowedValuesCollection.isClosed() ? obj.putArray("allOf") : obj.putArray("anyOf");
        dataTypeSchema.generateSchemaOrRef((ObjectNode)ObjectUtils.notNull((Object)ofArray.addObject()), state);
        ofArray.addObject().set("enum", (JsonNode)enumArray);
    }

    @Override
    public void gatherDefinitions(@NonNull Map<IDefineableJsonSchema.IKey, IDefinitionJsonSchema<?>> gatheredDefinitions, @NonNull IJsonGenerationState state) {
        state.getSchema(this.getDataTypeAdapter());
        IDefineableJsonSchema.IKey key = this.getKey();
        gatheredDefinitions.put(key, state.getSchema(this.getKey()));
    }
}

