/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen.json.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.core.model.IFieldDefinition;
import gov.nist.secauto.metaschema.core.model.IFlagInstance;
import gov.nist.secauto.metaschema.core.model.IValuedDefinition;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.schemagen.FlagInstanceFilter;
import gov.nist.secauto.metaschema.schemagen.json.IDataTypeJsonSchema;
import gov.nist.secauto.metaschema.schemagen.json.IDefineableJsonSchema;
import gov.nist.secauto.metaschema.schemagen.json.IDefinitionJsonSchema;
import gov.nist.secauto.metaschema.schemagen.json.IJsonGenerationState;
import gov.nist.secauto.metaschema.schemagen.json.impl.AbstractModelDefinitionJsonSchema;
import gov.nist.secauto.metaschema.schemagen.json.impl.FlagInstanceJsonProperty;
import gov.nist.secauto.metaschema.schemagen.json.impl.IJsonProperty;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;

public class FieldDefinitionJsonSchema
extends AbstractModelDefinitionJsonSchema<IFieldDefinition> {
    public FieldDefinitionJsonSchema(@NonNull IFieldDefinition definition, @Nullable String jsonKeyFlagName, @Nullable String discriminatorProperty, @Nullable String discriminatorValue, @NonNull IJsonGenerationState state) {
        super(definition, jsonKeyFlagName, discriminatorProperty, discriminatorValue);
        state.getDataTypeSchemaForDefinition((IValuedDefinition)definition);
    }

    @Override
    protected void generateBody(IJsonGenerationState state, ObjectNode obj) throws IOException {
        IFieldDefinition definition = (IFieldDefinition)this.getDefinition();
        Collection<? extends IFlagInstance> flags = definition.getFlagInstances();
        String discriminatorProperty = this.getDiscriminatorProperty();
        IFlagInstance jsonKeyFlag = definition.getJsonKey();
        if (discriminatorProperty == null && (flags.isEmpty() || jsonKeyFlag != null && flags.size() == 1)) {
            IDataTypeJsonSchema schema = state.getDataTypeSchemaForDefinition((IValuedDefinition)definition);
            schema.generateSchemaOrRef(obj, state);
        } else {
            obj.put("type", "object");
            IFlagInstance jsonValueKeyFlag = definition.getJsonValueKeyFlagInstance();
            flags = FlagInstanceFilter.filterFlags(flags, jsonKeyFlag, jsonValueKeyFlag);
            IJsonProperty.PropertyCollection properties = new IJsonProperty.PropertyCollection();
            if (discriminatorProperty != null) {
                ObjectNode discriminatorObj = state.getJsonNodeFactory().objectNode();
                discriminatorObj.put("const", this.getDiscriminatorValue());
                properties.addProperty(discriminatorProperty, discriminatorObj);
            }
            for (IFlagInstance iFlagInstance : flags) {
                assert (iFlagInstance != null);
                new FlagInstanceJsonProperty(iFlagInstance).generateProperty(properties, state);
            }
            if (jsonValueKeyFlag == null) {
                this.generateSimpleFieldValueInstance(properties, state);
            }
            properties.generate(obj);
            if (jsonValueKeyFlag == null) {
                obj.put("additionalProperties", false);
            } else {
                ObjectNode additionalPropertiesTypeNode = (ObjectNode)ObjectUtils.notNull((Object)JsonNodeFactory.instance.objectNode());
                IDataTypeJsonSchema iDataTypeJsonSchema = state.getDataTypeSchemaForDefinition((IValuedDefinition)definition);
                iDataTypeJsonSchema.generateSchemaOrRef(additionalPropertiesTypeNode, state);
                ObjectNode additionalPropertiesNode = (ObjectNode)ObjectUtils.notNull((Object)JsonNodeFactory.instance.objectNode());
                ArrayNode allOf = additionalPropertiesNode.putArray("allOf");
                allOf.add((JsonNode)additionalPropertiesTypeNode);
                allOf.addObject().put("minProperties", properties.getRequired().size() + 1).put("maxProperties", properties.getProperties().size() + 1);
                obj.set("additionalProperties", (JsonNode)additionalPropertiesNode);
            }
        }
    }

    public void generateSimpleFieldValueInstance(@NonNull IJsonProperty.PropertyCollection properties, @NonNull IJsonGenerationState state) {
        IFieldDefinition definition = (IFieldDefinition)this.getDefinition();
        String propertyName = definition.getEffectiveJsonValueKeyName();
        ObjectNode propertyObject = (ObjectNode)ObjectUtils.notNull((Object)JsonNodeFactory.instance.objectNode());
        IDataTypeJsonSchema schema = state.getDataTypeSchemaForDefinition((IValuedDefinition)definition);
        schema.generateSchemaOrRef(propertyObject, state);
        properties.addProperty(propertyName, propertyObject);
        properties.addRequired(propertyName);
    }

    @Override
    public void gatherDefinitions(@NonNull Map<IDefineableJsonSchema.IKey, IDefinitionJsonSchema<?>> gatheredDefinitions, @NonNull IJsonGenerationState state) {
        super.gatherDefinitions(gatheredDefinitions, state);
        IFieldDefinition definition = (IFieldDefinition)this.getDefinition();
        IDataTypeJsonSchema schema = state.getDataTypeSchemaForDefinition((IValuedDefinition)definition);
        if (schema instanceof IDefinitionJsonSchema) {
            ((IDefinitionJsonSchema)((Object)schema)).gatherDefinitions(gatheredDefinitions, state);
        }
    }
}

