/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen.json.impl;

import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.model.IDefinition;
import gov.nist.secauto.metaschema.core.model.IFlagDefinition;
import gov.nist.secauto.metaschema.core.model.IFlagInstance;
import gov.nist.secauto.metaschema.core.model.INamedModelElement;
import gov.nist.secauto.metaschema.core.model.IValuedDefinition;
import gov.nist.secauto.metaschema.core.model.IValuedInstance;
import gov.nist.secauto.metaschema.schemagen.json.IDataTypeJsonSchema;
import gov.nist.secauto.metaschema.schemagen.json.IDefineableJsonSchema;
import gov.nist.secauto.metaschema.schemagen.json.IDefinitionJsonSchema;
import gov.nist.secauto.metaschema.schemagen.json.IJsonGenerationState;
import gov.nist.secauto.metaschema.schemagen.json.impl.AbstractNamedInstanceJsonProperty;
import gov.nist.secauto.metaschema.schemagen.json.impl.MetadataUtils;
import java.util.Map;

public class FlagInstanceJsonProperty
extends AbstractNamedInstanceJsonProperty<IFlagInstance> {
    public FlagInstanceJsonProperty(@NonNull IFlagInstance instance) {
        super(instance);
    }

    @Override
    public boolean isRequired() {
        return ((IFlagInstance)this.getInstance()).isRequired();
    }

    @Override
    protected void generateMetadata(ObjectNode obj) {
        IFlagInstance instance = (IFlagInstance)this.getInstance();
        MetadataUtils.generateTitle((INamedModelElement)instance, obj);
        MetadataUtils.generateDescription(instance, obj);
        MetadataUtils.generateDefault((IValuedInstance)instance, obj);
    }

    @Override
    public void gatherDefinitions(@NonNull Map<IDefineableJsonSchema.IKey, IDefinitionJsonSchema<?>> gatheredDefinitions, @NonNull IJsonGenerationState state) {
        IFlagDefinition definition;
        IDataTypeJsonSchema dataTypeSchema = state.getDataTypeSchemaForDefinition((IValuedDefinition)((IFlagInstance)this.getInstance()).getDefinition());
        if (dataTypeSchema instanceof IDefinitionJsonSchema) {
            ((IDefinitionJsonSchema)((Object)dataTypeSchema)).gatherDefinitions(gatheredDefinitions, state);
        }
        if (!state.isInline((IDefinition)(definition = ((IFlagInstance)this.getInstance()).getDefinition()))) {
            state.getSchema(IDefineableJsonSchema.IKey.of((IDefinition)definition)).gatherDefinitions(gatheredDefinitions, state);
        }
    }

    @Override
    protected void generateBody(ObjectNode obj, IJsonGenerationState state) {
        IFlagInstance instance = (IFlagInstance)this.getInstance();
        IFlagDefinition definition = instance.getDefinition();
        IDataTypeJsonSchema dataTypeSchema = state.getDataTypeSchemaForDefinition((IValuedDefinition)definition);
        dataTypeSchema.generateSchemaOrRef(obj, state);
    }
}

