/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen.json.impl;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.core.configuration.IConfiguration;
import gov.nist.secauto.metaschema.core.datatype.IDataTypeAdapter;
import gov.nist.secauto.metaschema.core.model.IAssemblyDefinition;
import gov.nist.secauto.metaschema.core.model.IDefinition;
import gov.nist.secauto.metaschema.core.model.IFieldDefinition;
import gov.nist.secauto.metaschema.core.model.IFlagDefinition;
import gov.nist.secauto.metaschema.core.model.IModule;
import gov.nist.secauto.metaschema.core.model.IValuedDefinition;
import gov.nist.secauto.metaschema.core.model.constraint.IAllowedValue;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.schemagen.AbstractGenerationState;
import gov.nist.secauto.metaschema.schemagen.SchemaGenerationFeature;
import gov.nist.secauto.metaschema.schemagen.json.IDataTypeJsonSchema;
import gov.nist.secauto.metaschema.schemagen.json.IDefineableJsonSchema;
import gov.nist.secauto.metaschema.schemagen.json.IDefinitionJsonSchema;
import gov.nist.secauto.metaschema.schemagen.json.IJsonGenerationState;
import gov.nist.secauto.metaschema.schemagen.json.impl.AbstractDefinitionJsonSchema;
import gov.nist.secauto.metaschema.schemagen.json.impl.AssemblyDefinitionJsonSchema;
import gov.nist.secauto.metaschema.schemagen.json.impl.DataTypeJsonSchema;
import gov.nist.secauto.metaschema.schemagen.json.impl.DataTypeRestrictionDefinitionJsonSchema;
import gov.nist.secauto.metaschema.schemagen.json.impl.FieldDefinitionJsonSchema;
import gov.nist.secauto.metaschema.schemagen.json.impl.FlagDefinitionJsonSchema;
import gov.nist.secauto.metaschema.schemagen.json.impl.JsonDatatypeManager;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class JsonGenerationState
extends AbstractGenerationState<JsonGenerator, JsonDatatypeManager>
implements IJsonGenerationState {
    @NonNull
    private final JsonNodeFactory jsonNodeFactory = new JsonNodeFactory(true);
    @NonNull
    private final Map<IDefineableJsonSchema.IKey, IDefinitionJsonSchema<?>> schemaDefinitions = new HashMap();
    @NonNull
    private final Map<IValuedDefinition, IDataTypeJsonSchema> definitionValueToDataTypeSchemaMap = new ConcurrentHashMap<IValuedDefinition, IDataTypeJsonSchema>();
    @NonNull
    private final Map<IDataTypeAdapter<?>, IDataTypeJsonSchema> dataTypeToSchemaMap = new ConcurrentHashMap();

    public JsonGenerationState(@NonNull IModule module, @NonNull JsonGenerator writer, @NonNull IConfiguration<SchemaGenerationFeature<?>> configuration) {
        super(module, writer, configuration, new JsonDatatypeManager());
    }

    @Override
    @NonNull
    public <DEF extends IDefinition> IDefinitionJsonSchema<DEF> getSchema(@NonNull IDefineableJsonSchema.IKey key) {
        IDefinitionJsonSchema<?> retval = this.getDefinitionSchema(key, this);
        return (IDefinitionJsonSchema)ObjectUtils.asType((Object)ObjectUtils.requireNonNull(retval));
    }

    @Override
    @NonNull
    public IDataTypeJsonSchema getSchema(@NonNull IDataTypeAdapter<?> datatype) {
        IDataTypeJsonSchema retval = this.dataTypeToSchemaMap.get(datatype);
        if (retval == null) {
            retval = new DataTypeJsonSchema(((JsonDatatypeManager)this.getDatatypeManager()).getTypeNameForDatatype(datatype), datatype);
            this.dataTypeToSchemaMap.put(datatype, retval);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IDefinitionJsonSchema<?> getDefinitionSchema(@NonNull IDefineableJsonSchema.IKey key, @NonNull IJsonGenerationState state) {
        Map<IDefineableJsonSchema.IKey, IDefinitionJsonSchema<?>> map = this.schemaDefinitions;
        synchronized (map) {
            return this.schemaDefinitions.computeIfAbsent(key, k -> {
                IDefinitionJsonSchema<?> retval = JsonGenerationState.newJsonSchema(k.getDefinition(), k.getJsonKeyFlagName(), k.getDiscriminatorProperty(), k.getDiscriminatorValue(), state);
                assert (key.equals(retval.getKey()));
                return retval;
            });
        }
    }

    @Override
    public boolean isDefinitionRegistered(IDefinitionJsonSchema<?> schema) {
        return this.schemaDefinitions.containsKey(schema.getKey());
    }

    @Override
    public void registerDefinitionSchema(IDefinitionJsonSchema<?> schema) {
        IDefinitionJsonSchema<?> old = this.schemaDefinitions.put(schema.getKey(), schema);
        assert (old == null);
    }

    @NonNull
    private static IDefinitionJsonSchema<?> newJsonSchema(@NonNull IDefinition definition, @Nullable String jsonKeyFlagName, @Nullable String discriminatorProperty, @Nullable String discriminatorValue, @NonNull IJsonGenerationState state) {
        AbstractDefinitionJsonSchema retval;
        if (definition instanceof IFlagDefinition) {
            retval = new FlagDefinitionJsonSchema((IFlagDefinition)definition, state);
        } else if (definition instanceof IAssemblyDefinition) {
            retval = new AssemblyDefinitionJsonSchema((IAssemblyDefinition)definition, jsonKeyFlagName, discriminatorProperty, discriminatorValue, state);
        } else if (definition instanceof IFieldDefinition) {
            retval = new FieldDefinitionJsonSchema((IFieldDefinition)definition, jsonKeyFlagName, discriminatorProperty, discriminatorValue, state);
        } else {
            throw new IllegalArgumentException("Unsupported definition type" + definition.getClass().getName());
        }
        return retval;
    }

    public ObjectNode generateDefinitions() {
        HashMap gatheredDefinitions = new HashMap();
        this.getMetaschemaIndex().getDefinitions().stream().filter(entry -> entry.isRoot()).map(entry -> entry.getDefinition()).forEachOrdered(def -> {
            IDefinitionJsonSchema definitionSchema = this.getSchema(IDefineableJsonSchema.IKey.of(def));
            assert (definitionSchema != null);
            definitionSchema.gatherDefinitions(gatheredDefinitions, this);
        });
        ObjectNode definitionsObject = (ObjectNode)ObjectUtils.notNull((Object)JsonNodeFactory.instance.objectNode());
        gatheredDefinitions.values().stream().filter(schema -> !this.isInline((IDefinition)schema.getDefinition())).sorted(Comparator.comparing(schema -> schema.getDefinitionName(this))).forEachOrdered(schema -> schema.generateDefinition(this, definitionsObject));
        ((JsonDatatypeManager)this.getDatatypeManager()).generateDatatypes(definitionsObject);
        return definitionsObject;
    }

    @Override
    public JsonNodeFactory getJsonNodeFactory() {
        return this.jsonNodeFactory;
    }

    @Override
    @NonNull
    public IDataTypeJsonSchema getDataTypeSchemaForDefinition(@NonNull IValuedDefinition definition) {
        IDataTypeJsonSchema retval = this.definitionValueToDataTypeSchemaMap.get(definition);
        if (retval == null) {
            AbstractGenerationState.AllowedValueCollection allowedValuesCollection = JsonGenerationState.getContextIndependentEnumeratedValues(definition);
            List<IAllowedValue> allowedValues = allowedValuesCollection.getValues();
            IDataTypeAdapter dataTypeAdapter = definition.getJavaTypeAdapter();
            retval = this.getSchema(dataTypeAdapter);
            if (!allowedValues.isEmpty()) {
                retval = new DataTypeRestrictionDefinitionJsonSchema(definition, allowedValuesCollection);
            }
            this.definitionValueToDataTypeSchemaMap.put(definition, retval);
        }
        return retval;
    }

    public void writeStartObject() throws IOException {
        ((JsonGenerator)this.getWriter()).writeStartObject();
    }

    public void writeEndObject() throws IOException {
        ((JsonGenerator)this.getWriter()).writeEndObject();
    }

    public void writeField(String fieldName, String value) throws IOException {
        ((JsonGenerator)this.getWriter()).writeStringField(fieldName, value);
    }

    public void writeField(String fieldName, ObjectNode obj) throws IOException {
        JsonGenerator writer = (JsonGenerator)this.getWriter();
        writer.writeFieldName(fieldName);
        writer.writeTree((TreeNode)obj);
    }

    @Override
    public void flushWriter() throws IOException {
        ((JsonGenerator)this.getWriter()).flush();
    }
}

