/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen.json.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BigIntegerNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DecimalNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.datatype.IDataTypeAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.core.model.IModelElement;
import gov.nist.secauto.metaschema.core.model.INamedModelElement;
import gov.nist.secauto.metaschema.core.model.IValuedDefinition;
import gov.nist.secauto.metaschema.core.model.IValuedInstance;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class MetadataUtils {
    private MetadataUtils() {
    }

    public static void generateTitle(@NonNull INamedModelElement named, @NonNull ObjectNode obj) {
        String formalName = named.getEffectiveFormalName();
        if (formalName != null) {
            obj.put("title", formalName);
        }
    }

    public static <NAMED extends INamedModelElement & IModelElement> void generateDescription(@NonNull NAMED named, @NonNull ObjectNode obj) {
        MarkupMultiline remarks;
        MarkupLine description = named.getEffectiveDescription();
        StringBuilder retval = null;
        if (description != null) {
            retval = new StringBuilder().append(description.toMarkdown());
        }
        if ((remarks = named.getRemarks()) != null) {
            if (retval == null) {
                retval = new StringBuilder();
            } else {
                retval.append("\n\n");
            }
            retval.append(remarks.toMarkdown());
        }
        if (retval != null) {
            obj.put("description", retval.toString());
        }
    }

    public static void generateDefault(IValuedInstance instance, ObjectNode obj) {
        Object defaultValue = instance.getEffectiveDefaultValue();
        if (defaultValue != null) {
            IValuedDefinition definition = instance.getDefinition();
            IDataTypeAdapter adapter = definition.getJavaTypeAdapter();
            obj.set("default", MetadataUtils.toJsonValue(defaultValue, adapter));
        }
    }

    private static JsonNode toJsonValue(Object defaultValue, IDataTypeAdapter<?> adapter) {
        BigIntegerNode retval = null;
        switch (adapter.getJsonRawType()) {
            case BOOLEAN: {
                if (!(defaultValue instanceof Boolean)) break;
                retval = BooleanNode.valueOf((boolean)((Boolean)defaultValue));
                break;
            }
            case INTEGER: {
                if (defaultValue instanceof BigInteger) {
                    retval = BigIntegerNode.valueOf((BigInteger)((BigInteger)defaultValue));
                    break;
                }
                if (defaultValue instanceof Integer) {
                    retval = IntNode.valueOf((int)((Integer)defaultValue));
                    break;
                }
                if (!(defaultValue instanceof Long)) break;
                retval = LongNode.valueOf((long)((Long)defaultValue));
                break;
            }
            case NUMBER: {
                if (defaultValue instanceof BigDecimal) {
                    retval = DecimalNode.valueOf((BigDecimal)((BigDecimal)defaultValue));
                    break;
                }
                if (!(defaultValue instanceof Double)) break;
                retval = DoubleNode.valueOf((double)((Double)defaultValue));
                break;
            }
            case ANY: 
            case ARRAY: 
            case OBJECT: 
            case NULL: {
                throw new UnsupportedOperationException("Invalid type: " + defaultValue.getClass());
            }
        }
        if (retval == null) {
            retval = TextNode.valueOf((String)adapter.asString(defaultValue));
        }
        return retval;
    }
}

