/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen.json.impl.builder;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import gov.nist.secauto.metaschema.core.model.IDefinition;
import gov.nist.secauto.metaschema.core.model.IFieldDefinition;
import gov.nist.secauto.metaschema.core.model.IFlagDefinition;
import gov.nist.secauto.metaschema.core.model.IFlagInstance;
import gov.nist.secauto.metaschema.core.model.IModelDefinition;
import gov.nist.secauto.metaschema.core.model.INamedModelInstance;
import gov.nist.secauto.metaschema.core.model.INamedModelInstanceAbsolute;
import gov.nist.secauto.metaschema.core.model.INamedModelInstanceGrouped;
import gov.nist.secauto.metaschema.core.model.IValuedDefinition;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import gov.nist.secauto.metaschema.schemagen.json.IDataTypeJsonSchema;
import gov.nist.secauto.metaschema.schemagen.json.IDefineableJsonSchema;
import gov.nist.secauto.metaschema.schemagen.json.IDefinitionJsonSchema;
import gov.nist.secauto.metaschema.schemagen.json.IJsonGenerationState;
import gov.nist.secauto.metaschema.schemagen.json.impl.builder.AbstractBuilder;
import gov.nist.secauto.metaschema.schemagen.json.impl.builder.IModelInstanceBuilder;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractCollectionBuilder<T extends AbstractCollectionBuilder<T>>
extends AbstractBuilder<T>
implements IModelInstanceBuilder<T> {
    private int minOccurrence = 0;
    private int maxOccurrence = 1;
    @NonNull
    private final List<IModelInstanceBuilder.IType> types = new LinkedList<IModelInstanceBuilder.IType>();

    @Override
    public T addItemType(INamedModelInstanceAbsolute itemType) {
        this.types.add(new AbsoluteType(itemType));
        return (T)((AbstractCollectionBuilder)this.thisBuilder());
    }

    @Override
    public T addItemType(INamedModelInstanceGrouped itemType) {
        this.types.add(new GroupedType(itemType));
        return (T)((AbstractCollectionBuilder)this.thisBuilder());
    }

    @Override
    public List<IModelInstanceBuilder.IType> getTypes() {
        return CollectionUtil.unmodifiableList(this.types);
    }

    @Override
    public T minItems(int min) {
        if (min < 0) {
            throw new IllegalArgumentException(String.format("The minimum value '%d' cannot be negative.", min));
        }
        this.minOccurrence = min;
        return (T)((AbstractCollectionBuilder)this.thisBuilder());
    }

    @Override
    public T maxItems(int max) {
        if (max < -1 || max == 0) {
            throw new IllegalArgumentException(String.format("The maximum value '%d' must be -1 or a positive value.", max));
        }
        this.maxOccurrence = max;
        return (T)((AbstractCollectionBuilder)this.thisBuilder());
    }

    @Override
    public int getMinOccurrence() {
        return this.minOccurrence;
    }

    @Override
    public int getMaxOccurrence() {
        return this.maxOccurrence;
    }

    protected void buildInternal(@NonNull ObjectNode object, @NonNull IJsonGenerationState state) {
        if (this.types.size() == 1) {
            this.types.iterator().next().build(object, state);
        } else if (this.types.size() > 1) {
            ArrayNode anyOf = object.putArray("anyOf");
            for (IModelInstanceBuilder.IType type : this.types) {
                type.build(anyOf, state);
            }
        }
    }

    private static final class AbsoluteType
    extends Type<INamedModelInstanceAbsolute> {
        private AbsoluteType(@NonNull INamedModelInstanceAbsolute namedModelInstance) {
            super(namedModelInstance);
        }
    }

    private static final class GroupedType
    extends Type<INamedModelInstanceGrouped> {
        private GroupedType(@NonNull INamedModelInstanceGrouped namedModelInstance) {
            super(namedModelInstance);
        }
    }

    private static abstract class Type<T extends INamedModelInstance>
    implements IModelInstanceBuilder.IType {
        @NonNull
        private final T namedModelInstance;
        @Nullable
        private final IFlagInstance jsonKeyFlag;
        @Nullable
        private final String discriminatorProperty;
        @Nullable
        private final String discriminatorValue;
        @NonNull
        private final IDefineableJsonSchema.IKey key;

        @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"}, justification="Use of final fields")
        protected Type(@NonNull T instance) {
            this.namedModelInstance = instance;
            this.jsonKeyFlag = instance.getEffectiveJsonKey();
            if (instance instanceof INamedModelInstanceGrouped) {
                INamedModelInstanceGrouped grouped = (INamedModelInstanceGrouped)instance;
                this.discriminatorProperty = grouped.getParentContainer().getJsonDiscriminatorProperty();
                this.discriminatorValue = grouped.getEffectiveDisciminatorValue();
            } else {
                this.discriminatorProperty = null;
                this.discriminatorValue = null;
            }
            this.key = IDefineableJsonSchema.IKey.of((IDefinition)instance.getDefinition(), this.jsonKeyFlag == null ? null : this.jsonKeyFlag.getName(), this.discriminatorProperty, this.discriminatorValue);
        }

        @NonNull
        protected T getNamedModelInstance() {
            return this.namedModelInstance;
        }

        @Nullable
        protected IFlagInstance getJsonKeyFlag() {
            return this.jsonKeyFlag;
        }

        @Nullable
        protected String getJsonKeyFlagName() {
            return this.jsonKeyFlag == null ? null : this.jsonKeyFlag.getEffectiveName();
        }

        @Nullable
        protected String getDiscriminatorProperty() {
            return this.discriminatorProperty;
        }

        @Nullable
        protected String getDiscriminatorValue() {
            return this.discriminatorValue;
        }

        @Override
        public IDefinitionJsonSchema<IFlagDefinition> getJsonKeyFlagSchema(@NonNull IJsonGenerationState state) {
            IFlagInstance jsonKey = this.getJsonKeyFlag();
            return jsonKey == null ? null : state.getSchema(IDefineableJsonSchema.IKey.of((IDefinition)jsonKey.getDefinition()));
        }

        @Override
        public IDataTypeJsonSchema getJsonKeyDataTypeSchema(IJsonGenerationState state) {
            IFlagInstance jsonKey = this.getJsonKeyFlag();
            return jsonKey == null ? null : state.getDataTypeSchemaForDefinition((IValuedDefinition)jsonKey.getDefinition());
        }

        @Override
        public IDefinitionJsonSchema<IModelDefinition> getJsonSchema(IJsonGenerationState state) {
            return state.getSchema(this.key);
        }

        @Override
        public void build(@NonNull ArrayNode anyOf, @NonNull IJsonGenerationState state) {
            this.build(anyOf.addObject(), state);
        }

        @Override
        public void build(@NonNull ObjectNode object, @NonNull IJsonGenerationState state) {
            IModelDefinition definition = this.getNamedModelInstance().getDefinition();
            int flagCount = definition.getFlagInstances().size();
            if (this.jsonKeyFlag != null) {
                --flagCount;
            }
            if (flagCount > 0) {
                IDefinitionJsonSchema<IModelDefinition> schema = this.getJsonSchema(state);
                schema.generateSchemaOrRef(object, state);
            } else if (definition instanceof IFieldDefinition) {
                IDataTypeJsonSchema schema = state.getSchema(((IFieldDefinition)definition).getJavaTypeAdapter());
                schema.generateSchemaOrRef(object, state);
            }
        }
    }
}

