/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen.json.impl.builder;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.core.model.IChoiceGroupInstance;
import gov.nist.secauto.metaschema.core.model.IGroupable;
import gov.nist.secauto.metaschema.core.model.IModelDefinition;
import gov.nist.secauto.metaschema.core.model.IModelInstance;
import gov.nist.secauto.metaschema.core.model.INamedModelInstanceAbsolute;
import gov.nist.secauto.metaschema.core.model.INamedModelInstanceGrouped;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.schemagen.json.IDataTypeJsonSchema;
import gov.nist.secauto.metaschema.schemagen.json.IDefineableJsonSchema;
import gov.nist.secauto.metaschema.schemagen.json.IDefinitionJsonSchema;
import gov.nist.secauto.metaschema.schemagen.json.IJsonGenerationState;
import gov.nist.secauto.metaschema.schemagen.json.impl.builder.ArrayBuilder;
import gov.nist.secauto.metaschema.schemagen.json.impl.builder.IBuilder;
import gov.nist.secauto.metaschema.schemagen.json.impl.builder.KeyedObjectBuilder;
import gov.nist.secauto.metaschema.schemagen.json.impl.builder.SingletonBuilder;
import gov.nist.secauto.metaschema.schemagen.json.impl.builder.SingletonOrListBuilder;
import java.util.List;
import java.util.Map;

public interface IModelInstanceBuilder<T extends IModelInstanceBuilder<T>>
extends IBuilder<T> {
    @NonNull
    public T addItemType(@NonNull INamedModelInstanceGrouped var1);

    @NonNull
    public T addItemType(@NonNull INamedModelInstanceAbsolute var1);

    @NonNull
    public T minItems(int var1);

    @NonNull
    public T maxItems(int var1);

    @NonNull
    public List<IType> getTypes();

    public int getMinOccurrence();

    public int getMaxOccurrence();

    @NonNull
    public static <I extends IModelInstance & IGroupable> IModelInstanceBuilder<?> builder(@NonNull I instance) {
        IModelInstanceBuilder<?> builder;
        if (instance instanceof INamedModelInstanceAbsolute) {
            INamedModelInstanceAbsolute named = (INamedModelInstanceAbsolute)instance;
            builder = IModelInstanceBuilder.newCollectionBuilder((IGroupable)named);
            builder.addItemType(named);
        } else if (instance instanceof IChoiceGroupInstance) {
            IChoiceGroupInstance choice = (IChoiceGroupInstance)instance;
            builder = IModelInstanceBuilder.newCollectionBuilder((IGroupable)choice);
            for (INamedModelInstanceGrouped groupedInstance : choice.getNamedModelInstances()) {
                if (!1.$assertionsDisabled && groupedInstance == null) {
                    throw new AssertionError();
                }
                builder.addItemType(groupedInstance);
            }
        } else {
            throw new UnsupportedOperationException("Unsupported named model instance type: " + instance.getClass().getName());
        }
        return builder;
    }

    @NonNull
    public static IModelInstanceBuilder<?> newCollectionBuilder(@NonNull IGroupable groupable) {
        IModelInstanceBuilder<ArrayBuilder> retval;
        JsonGroupAsBehavior behavior = groupable.getJsonGroupAsBehavior();
        switch (behavior) {
            case LIST: {
                retval = new ArrayBuilder();
                break;
            }
            case SINGLETON_OR_LIST: {
                retval = new SingletonOrListBuilder();
                break;
            }
            case KEYED: {
                retval = new KeyedObjectBuilder();
                break;
            }
            case NONE: {
                retval = new SingletonBuilder();
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported group-as in-json binding '%s'.", behavior));
            }
        }
        retval.minItems(groupable.getMinOccurs());
        retval.maxItems(groupable.getMaxOccurs());
        return retval;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public static interface IType {
        @Nullable
        public IDefineableJsonSchema getJsonKeyFlagSchema(@NonNull IJsonGenerationState var1);

        @Nullable
        public IDataTypeJsonSchema getJsonKeyDataTypeSchema(@NonNull IJsonGenerationState var1);

        @NonNull
        public IDefinitionJsonSchema<IModelDefinition> getJsonSchema(@NonNull IJsonGenerationState var1);

        public void build(@NonNull ArrayNode var1, @NonNull IJsonGenerationState var2);

        public void build(@NonNull ObjectNode var1, @NonNull IJsonGenerationState var2);

        default public void gatherDefinitions(@NonNull Map<IDefineableJsonSchema.IKey, IDefinitionJsonSchema<?>> gatheredDefinitions, @NonNull IJsonGenerationState state) {
            IDefinitionJsonSchema<IModelDefinition> schema = this.getJsonSchema(state);
            schema.gatherDefinitions(gatheredDefinitions, state);
        }
    }
}

