/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen.json.impl.builder;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import gov.nist.secauto.metaschema.core.model.IFieldInstance;
import gov.nist.secauto.metaschema.core.model.IModelDefinition;
import gov.nist.secauto.metaschema.core.model.INamedModelInstanceAbsolute;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.schemagen.json.IJsonGenerationState;
import gov.nist.secauto.metaschema.schemagen.json.impl.builder.AbstractCollectionBuilder;
import gov.nist.secauto.metaschema.schemagen.json.impl.builder.IModelInstanceBuilder;
import java.util.List;

public class KeyedObjectBuilder
extends AbstractCollectionBuilder<KeyedObjectBuilder> {
    @Override
    protected KeyedObjectBuilder thisBuilder() {
        return this;
    }

    @Override
    public void build(ObjectNode object, IJsonGenerationState state) {
        List<IModelInstanceBuilder.IType> types;
        object.put("type", "object");
        if (this.getMinOccurrence() > 0) {
            object.put("minProperties", this.getMinOccurrence());
        }
        if (this.getMaxOccurrence() != -1) {
            object.put("maxProperties", this.getMaxOccurrence());
        }
        if (!(types = this.getTypes()).isEmpty()) {
            ObjectNode propertyNames = (ObjectNode)ObjectUtils.notNull((Object)object.putObject("propertyNames"));
            if (types.size() == 1) {
                types.iterator().next().build(propertyNames, state);
            } else {
                ArrayNode anyOf = propertyNames.putArray("anyOf");
                for (IModelInstanceBuilder.IType type : types) {
                    type.build((ObjectNode)ObjectUtils.notNull((Object)anyOf.objectNode()), state);
                }
            }
        }
        if (!types.isEmpty()) {
            ObjectNode patternProperties = (ObjectNode)ObjectUtils.notNull((Object)object.putObject("patternProperties"));
            ObjectNode wildcard = patternProperties.putObject("^.*$");
            if (types.size() == 1) {
                types.iterator().next().build(wildcard, state);
            } else {
                ArrayNode oneOf = wildcard.putArray("anyOf");
                for (IModelInstanceBuilder.IType type : types) {
                    type.build(oneOf, state);
                }
            }
        }
    }

    @Override
    public KeyedObjectBuilder addItemType(INamedModelInstanceAbsolute itemType) {
        IModelDefinition definition = itemType.getDefinition();
        int flagCount = definition.getFlagInstances().size();
        if (definition.getJsonKey() != null) {
            --flagCount;
        }
        if (flagCount > 0 || itemType instanceof IFieldInstance) {
            super.addItemType(itemType);
        }
        return this;
    }
}

