/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen.json.impl.builder;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import gov.nist.secauto.metaschema.core.model.INamedModelInstanceAbsolute;
import gov.nist.secauto.metaschema.core.model.INamedModelInstanceGrouped;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.schemagen.json.IJsonGenerationState;
import gov.nist.secauto.metaschema.schemagen.json.impl.builder.ArrayBuilder;
import gov.nist.secauto.metaschema.schemagen.json.impl.builder.IModelInstanceBuilder;
import gov.nist.secauto.metaschema.schemagen.json.impl.builder.SingletonBuilder;
import java.util.List;

public class SingletonOrListBuilder
implements IModelInstanceBuilder<SingletonOrListBuilder> {
    private int minOccurrence = 0;
    private final ArrayBuilder arrayBuilder = new ArrayBuilder();
    private final SingletonBuilder singletonBuilder;

    public SingletonOrListBuilder() {
        this.arrayBuilder.minItems(2);
        this.singletonBuilder = new SingletonBuilder();
    }

    @Override
    public List<IModelInstanceBuilder.IType> getTypes() {
        return this.arrayBuilder.getTypes();
    }

    @Override
    public SingletonOrListBuilder addItemType(INamedModelInstanceGrouped itemType) {
        this.arrayBuilder.addItemType(itemType);
        this.singletonBuilder.addItemType(itemType);
        return this;
    }

    @Override
    public SingletonOrListBuilder addItemType(INamedModelInstanceAbsolute itemType) {
        this.arrayBuilder.addItemType(itemType);
        this.singletonBuilder.addItemType(itemType);
        return this;
    }

    @Override
    public void build(ObjectNode object, IJsonGenerationState state) {
        ArrayNode oneOf = object.putArray("oneOf");
        this.singletonBuilder.build((ObjectNode)ObjectUtils.notNull((Object)oneOf.addObject()), state);
        this.arrayBuilder.build((ObjectNode)ObjectUtils.notNull((Object)oneOf.addObject()), state);
    }

    @Override
    public SingletonOrListBuilder minItems(int min) {
        this.minOccurrence = min;
        this.arrayBuilder.minItems(Integer.max(2, min));
        if (min > 0) {
            this.singletonBuilder.minItems(1);
        }
        return this;
    }

    @Override
    public SingletonOrListBuilder maxItems(int max) {
        this.arrayBuilder.maxItems(max);
        return this;
    }

    @Override
    public int getMinOccurrence() {
        return this.minOccurrence;
    }

    @Override
    public int getMaxOccurrence() {
        return this.arrayBuilder.getMaxOccurrence();
    }
}

