/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen.xml.datatype;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.model.IModule;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.schemagen.datatype.IDatatypeContent;
import gov.nist.secauto.metaschema.schemagen.xml.datatype.AbstractXmlDatatypeProvider;
import gov.nist.secauto.metaschema.schemagen.xml.datatype.JDom2DatatypeContent;
import gov.nist.secauto.metaschema.schemagen.xml.datatype.JDom2XmlSchemaLoader;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jdom2.Element;

public abstract class AbstractXmlMarkupDatatypeProvider
extends AbstractXmlDatatypeProvider {
    @Override
    protected InputStream getSchemaResource() {
        return IModule.class.getResourceAsStream(this.getSchemaResourcePath());
    }

    @NonNull
    protected abstract String getSchemaResourcePath();

    @Override
    protected List<Element> queryElements(JDom2XmlSchemaLoader loader) {
        return loader.getContent("/xs:schema/*", CollectionUtil.singletonMap((Object)"xs", (Object)"http://www.w3.org/2001/XMLSchema"));
    }

    @NonNull
    protected abstract String getDataTypeName();

    @Override
    protected Map<String, IDatatypeContent> handleResults(@NonNull List<Element> items) {
        String dataTypeName = this.getDataTypeName();
        return CollectionUtil.singletonMap((Object)dataTypeName, (Object)new JDom2DatatypeContent(dataTypeName, (List)ObjectUtils.notNull(items.stream().filter(element -> !"include".equals(element.getName())).collect(Collectors.toList())), CollectionUtil.emptyList()));
    }
}

