/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen.xml.datatype;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.model.IModule;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.schemagen.datatype.IDatatypeContent;
import gov.nist.secauto.metaschema.schemagen.xml.datatype.AbstractXmlDatatypeProvider;
import gov.nist.secauto.metaschema.schemagen.xml.datatype.JDom2DatatypeContent;
import gov.nist.secauto.metaschema.schemagen.xml.datatype.JDom2XmlSchemaLoader;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jdom2.Element;
import org.jdom2.filter.Filters;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;

public class XmlCoreDatatypeProvider
extends AbstractXmlDatatypeProvider {
    @Override
    protected InputStream getSchemaResource() {
        return IModule.class.getResourceAsStream("/schema/xml/metaschema-datatypes.xsd");
    }

    @Override
    protected List<Element> queryElements(JDom2XmlSchemaLoader loader) {
        return loader.getContent("/xs:schema/xs:simpleType", CollectionUtil.singletonMap((Object)"xs", (Object)"http://www.w3.org/2001/XMLSchema"));
    }

    @NonNull
    private static List<String> analyzeDependencies(@NonNull Element element) {
        XPathExpression xpath = XPathFactory.instance().compile(".//@base", Filters.attribute());
        return (List)ObjectUtils.notNull(xpath.evaluate((Object)element).stream().map(attr -> attr.getValue()).filter(type -> !type.startsWith("xs:")).distinct().collect(Collectors.toList()));
    }

    @Override
    @NonNull
    protected Map<String, IDatatypeContent> handleResults(@NonNull List<Element> items) {
        return (Map)ObjectUtils.notNull((Object)items.stream().map(element -> new JDom2DatatypeContent((String)ObjectUtils.requireNonNull((Object)element.getAttributeValue("name")), CollectionUtil.singletonList((Object)element), XmlCoreDatatypeProvider.analyzeDependencies(element))).collect(Collectors.toMap(content -> content.getTypeName(), Function.identity(), (e1, e2) -> e2, LinkedHashMap::new)));
    }
}

