/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen.xml.impl;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.core.model.IDefinition;
import gov.nist.secauto.metaschema.core.model.IModelElement;
import gov.nist.secauto.metaschema.core.model.INamedInstance;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import gov.nist.secauto.metaschema.schemagen.SchemaGenerationException;
import gov.nist.secauto.metaschema.schemagen.xml.impl.XmlGenerationState;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;

public final class DocumentationGenerator {
    @Nullable
    private final String formalName;
    @Nullable
    private final MarkupLine description;
    @NonNull
    private final List<MarkupMultiline> remarks;
    @NonNull
    private final IModelElement modelElement;

    private DocumentationGenerator(@NonNull IDefinition definition) {
        this.formalName = definition.getEffectiveFormalName();
        this.description = definition.getEffectiveDescription();
        MarkupMultiline remarks = definition.getRemarks();
        this.remarks = remarks == null ? CollectionUtil.emptyList() : CollectionUtil.singletonList((Object)remarks);
        this.modelElement = definition;
    }

    private DocumentationGenerator(@NonNull INamedInstance instance) {
        this.formalName = instance.getEffectiveFormalName();
        this.description = instance.getEffectiveDescription();
        ArrayList<MarkupMultiline> remarks = new ArrayList<MarkupMultiline>(2);
        MarkupMultiline remark = instance.getRemarks();
        if (remark != null) {
            remarks.add(remark);
        }
        if ((remark = instance.getDefinition().getRemarks()) != null) {
            remarks.add(remark);
        }
        this.remarks = CollectionUtil.listOrEmpty(remarks);
        this.modelElement = instance;
    }

    @Nullable
    public String getFormalName() {
        return this.formalName;
    }

    @Nullable
    public MarkupLine getDescription() {
        return this.description;
    }

    @NonNull
    public List<MarkupMultiline> getRemarks() {
        return this.remarks;
    }

    @NonNull
    public IModelElement getModelElement() {
        return this.modelElement;
    }

    private void generate(@NonNull XmlGenerationState state) {
        String formalName = this.getFormalName();
        MarkupLine description = this.getDescription();
        List<MarkupMultiline> remarks = this.getRemarks();
        if (formalName != null || description != null || !remarks.isEmpty()) {
            DocumentationGenerator.generateDocumentation(formalName, description, remarks, state.getNS(this.getModelElement()), state);
        }
    }

    public static void generateDocumentation(@NonNull IDefinition definition, @NonNull XmlGenerationState state) {
        new DocumentationGenerator(definition).generate(state);
    }

    public static void generateDocumentation(@NonNull INamedInstance instance, @NonNull XmlGenerationState state) {
        new DocumentationGenerator(instance).generate(state);
    }

    public static void generateDocumentation(@Nullable String formalName, @Nullable MarkupLine description, @NonNull List<MarkupMultiline> remarks, @NonNull String xmlNS, @NonNull XmlGenerationState state) {
        try {
            state.writeStartElement("xs", "annotation", "http://www.w3.org/2001/XMLSchema");
            if (formalName != null || description != null) {
                state.writeStartElement("xs", "appinfo", "http://www.w3.org/2001/XMLSchema");
                if (formalName != null) {
                    state.writeStartElement(xmlNS, "formal-name");
                    state.writeCharacters(formalName);
                    state.writeEndElement();
                }
                if (description != null) {
                    state.writeStartElement(xmlNS, "description");
                    description.writeXHtml(xmlNS, state.getXMLStreamWriter());
                    state.writeEndElement();
                }
                state.writeEndElement();
            }
            state.writeStartElement("xs", "documentation", "http://www.w3.org/2001/XMLSchema");
            state.writeNamespace("", "http://www.w3.org/1999/xhtml");
            if (description != null) {
                state.writeStartElement("http://www.w3.org/1999/xhtml", "p");
                if (formalName != null) {
                    state.writeStartElement("http://www.w3.org/1999/xhtml", "b");
                    state.writeCharacters(formalName);
                    state.writeEndElement();
                    state.writeCharacters(": ");
                }
                description.writeXHtml("http://www.w3.org/1999/xhtml", state.getXMLStreamWriter());
                state.writeEndElement();
            }
            for (MarkupMultiline remark : remarks) {
                remark.writeXHtml("http://www.w3.org/1999/xhtml", state.getXMLStreamWriter());
            }
            state.writeEndElement();
            state.writeEndElement();
        }
        catch (XMLStreamException ex) {
            throw new SchemaGenerationException(ex);
        }
    }
}

