/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen.xml.schematype;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.model.IDefinition;
import gov.nist.secauto.metaschema.core.model.IFlagInstance;
import gov.nist.secauto.metaschema.core.model.IModelDefinition;
import gov.nist.secauto.metaschema.core.model.INamedInstance;
import gov.nist.secauto.metaschema.schemagen.SchemaGenerationException;
import gov.nist.secauto.metaschema.schemagen.xml.impl.DocumentationGenerator;
import gov.nist.secauto.metaschema.schemagen.xml.impl.XmlGenerationState;
import gov.nist.secauto.metaschema.schemagen.xml.schematype.AbstractXmlType;
import gov.nist.secauto.metaschema.schemagen.xml.schematype.IXmlComplexType;
import gov.nist.secauto.metaschema.schemagen.xml.schematype.IXmlType;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public abstract class AbstractXmlComplexType<D extends IModelDefinition>
extends AbstractXmlType
implements IXmlComplexType {
    @NonNull
    private final D definition;

    public AbstractXmlComplexType(@NonNull QName qname, @NonNull D definition) {
        super(qname);
        this.definition = definition;
    }

    @NonNull
    public D getDefinition() {
        return this.definition;
    }

    @Override
    public void generate(@NonNull XmlGenerationState state) {
        try {
            state.writeStartElement("xs", "complexType", "http://www.w3.org/2001/XMLSchema");
            if (!this.isInline(state)) {
                state.writeAttribute("name", this.getTypeName());
            }
            DocumentationGenerator.generateDocumentation(this.getDefinition(), state);
            this.generateTypeBody(state);
            state.writeEndElement();
        }
        catch (XMLStreamException ex) {
            throw new SchemaGenerationException(ex);
        }
    }

    protected abstract void generateTypeBody(@NonNull XmlGenerationState var1) throws XMLStreamException;

    protected static void generateFlagInstance(@NonNull IFlagInstance instance, @NonNull XmlGenerationState state) throws XMLStreamException {
        IXmlType type;
        state.writeStartElement("xs", "attribute", "http://www.w3.org/2001/XMLSchema");
        state.writeAttribute("name", instance.getEffectiveName());
        if (instance.isRequired()) {
            state.writeAttribute("use", "required");
        }
        if ((type = state.getXmlForDefinition((IDefinition)instance.getDefinition())).isGeneratedType(state) && type.isInline(state)) {
            DocumentationGenerator.generateDocumentation((INamedInstance)instance, state);
            type.generate(state);
        } else {
            state.writeAttribute("type", type.getTypeReference());
            DocumentationGenerator.generateDocumentation((INamedInstance)instance, state);
        }
        state.writeEndElement();
    }

    @Override
    public boolean isInline(XmlGenerationState state) {
        return state.isInline((IDefinition)this.getDefinition());
    }
}

