/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen.xml.schematype;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.datatype.IDataTypeAdapter;
import gov.nist.secauto.metaschema.core.model.IFieldDefinition;
import gov.nist.secauto.metaschema.core.model.IFlagInstance;
import gov.nist.secauto.metaschema.core.model.IValuedDefinition;
import gov.nist.secauto.metaschema.schemagen.xml.impl.XmlGenerationState;
import gov.nist.secauto.metaschema.schemagen.xml.schematype.AbstractXmlComplexType;
import gov.nist.secauto.metaschema.schemagen.xml.schematype.IXmlSimpleType;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public class XmlComplexTypeFieldDefinition
extends AbstractXmlComplexType<IFieldDefinition> {
    public XmlComplexTypeFieldDefinition(@NonNull QName qname, @NonNull IFieldDefinition definition) {
        super(qname, definition);
    }

    @Override
    protected void generateTypeBody(XmlGenerationState state) throws XMLStreamException {
        IFieldDefinition definition = (IFieldDefinition)this.getDefinition();
        IXmlSimpleType valueType = state.getSimpleType((IValuedDefinition)definition);
        IDataTypeAdapter<?> datatype = valueType.getDataTypeAdapter();
        String xmlContentType = datatype.isXmlMixed() ? "complexContent" : "simpleContent";
        state.writeStartElement("xs", xmlContentType, "http://www.w3.org/2001/XMLSchema");
        state.writeStartElement("xs", "extension", "http://www.w3.org/2001/XMLSchema");
        state.writeAttribute("base", valueType.getTypeReference());
        for (IFlagInstance flagInstance : definition.getFlagInstances()) {
            assert (flagInstance != null);
            XmlComplexTypeFieldDefinition.generateFlagInstance(flagInstance, state);
        }
        state.writeEndElement();
        state.writeEndElement();
    }
}

