/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.core.configuration.IConfiguration;
import gov.nist.secauto.metaschema.core.model.IAssemblyDefinition;
import gov.nist.secauto.metaschema.core.model.IDefinition;
import gov.nist.secauto.metaschema.core.model.IModule;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.schemagen.AbstractGenerationState;
import gov.nist.secauto.metaschema.schemagen.ISchemaGenerator;
import gov.nist.secauto.metaschema.schemagen.ModuleIndex;
import gov.nist.secauto.metaschema.schemagen.SchemaGenerationException;
import gov.nist.secauto.metaschema.schemagen.SchemaGenerationFeature;
import gov.nist.secauto.metaschema.schemagen.datatype.IDatatypeManager;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiConsumer;

public abstract class AbstractSchemaGenerator<T extends AutoCloseable, D extends IDatatypeManager, S extends AbstractGenerationState<T, D>>
implements ISchemaGenerator {
    @NonNull
    protected abstract T newWriter(@NonNull Writer var1);

    @NonNull
    protected abstract S newGenerationState(@NonNull IModule var1, @NonNull T var2, @NonNull IConfiguration<SchemaGenerationFeature<?>> var3);

    protected abstract void generateSchema(@NonNull S var1);

    @Override
    public void generateFromModule(IModule metaschema, Writer out, IConfiguration<SchemaGenerationFeature<?>> configuration) {
        try {
            T schemaWriter = this.newWriter(out);
            S generationState = this.newGenerationState(metaschema, schemaWriter, configuration);
            this.generateSchema(generationState);
            generationState.flushWriter();
        }
        catch (SchemaGenerationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SchemaGenerationException(ex);
        }
    }

    protected List<IAssemblyDefinition> analyzeDefinitions(@NonNull S generationState, @Nullable BiConsumer<ModuleIndex.DefinitionEntry, IDefinition> handler) {
        LinkedList<IAssemblyDefinition> rootAssemblyDefinitions = new LinkedList<IAssemblyDefinition>();
        for (ModuleIndex.DefinitionEntry entry : ((AbstractGenerationState)generationState).getMetaschemaIndex().getDefinitions()) {
            boolean referenced;
            IDefinition definition = (IDefinition)ObjectUtils.notNull((Object)entry.getDefinition());
            if (definition instanceof IAssemblyDefinition && ((IAssemblyDefinition)definition).isRoot()) {
                IAssemblyDefinition assemblyDefinition = (IAssemblyDefinition)definition;
                rootAssemblyDefinitions.add(assemblyDefinition);
            }
            if (!(referenced = entry.isReferenced()) || handler == null) continue;
            handler.accept(entry, definition);
        }
        return rootAssemblyDefinitions;
    }
}

