/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.configuration.IConfiguration;
import gov.nist.secauto.metaschema.core.model.IDefinition;
import gov.nist.secauto.metaschema.schemagen.ChoiceNotInlineStrategy;
import gov.nist.secauto.metaschema.schemagen.ModuleIndex;
import gov.nist.secauto.metaschema.schemagen.SchemaGenerationFeature;

public interface IInlineStrategy {
    @NonNull
    public static final IInlineStrategy NONE_INLINE = new IInlineStrategy(){

        @Override
        public boolean isInline(@NonNull IDefinition definition, @NonNull ModuleIndex metaschemaIndex) {
            return false;
        }
    };
    @NonNull
    public static final IInlineStrategy DEFINED_AS_INLINE = new IInlineStrategy(){

        @Override
        public boolean isInline(@NonNull IDefinition definition, @NonNull ModuleIndex metaschemaIndex) {
            return definition.isInline();
        }
    };
    @NonNull
    public static final IInlineStrategy CHOICE_NOT_INLINE = new ChoiceNotInlineStrategy();

    @NonNull
    public static IInlineStrategy newInlineStrategy(@NonNull IConfiguration<SchemaGenerationFeature<?>> configuration) {
        IInlineStrategy retval = configuration.isFeatureEnabled(SchemaGenerationFeature.INLINE_DEFINITIONS) ? (configuration.isFeatureEnabled(SchemaGenerationFeature.INLINE_CHOICE_DEFINITIONS) ? DEFINED_AS_INLINE : CHOICE_NOT_INLINE) : NONE_INLINE;
        return retval;
    }

    public boolean isInline(@NonNull IDefinition var1, @NonNull ModuleIndex var2);
}

