/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.model.IAssemblyDefinition;
import gov.nist.secauto.metaschema.core.model.IAssemblyInstance;
import gov.nist.secauto.metaschema.core.model.IChoiceInstance;
import gov.nist.secauto.metaschema.core.model.IDefinition;
import gov.nist.secauto.metaschema.core.model.IFieldDefinition;
import gov.nist.secauto.metaschema.core.model.IFieldInstance;
import gov.nist.secauto.metaschema.core.model.IFlagDefinition;
import gov.nist.secauto.metaschema.core.model.IFlagInstance;
import gov.nist.secauto.metaschema.core.model.IModelDefinition;
import gov.nist.secauto.metaschema.core.model.IModule;
import gov.nist.secauto.metaschema.core.model.INamedInstance;
import gov.nist.secauto.metaschema.core.model.INamedModelInstance;
import gov.nist.secauto.metaschema.core.model.INamedModelInstanceGrouped;
import gov.nist.secauto.metaschema.core.model.ModelWalker;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.schemagen.IInlineStrategy;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public class ModuleIndex {
    private final Map<IDefinition, DefinitionEntry> index = new LinkedHashMap<IDefinition, DefinitionEntry>();

    @NonNull
    public static ModuleIndex indexDefinitions(@NonNull IModule module, @NonNull IInlineStrategy inlineStrategy) {
        Collection definitions = module.getExportedRootAssemblyDefinitions();
        ModuleIndex index = new ModuleIndex();
        if (!definitions.isEmpty()) {
            IndexVisitor visitor = new IndexVisitor(index, inlineStrategy);
            for (IAssemblyDefinition definition : definitions) {
                assert (definition != null);
                visitor.walk((IAssemblyDefinition)ObjectUtils.requireNonNull((Object)definition));
            }
        }
        return index;
    }

    public boolean hasEntry(@NonNull IDefinition definition) {
        return this.index.containsKey(definition);
    }

    @NonNull
    public DefinitionEntry getEntry(@NonNull IDefinition definition) {
        return (DefinitionEntry)ObjectUtils.notNull((Object)this.index.computeIfAbsent(definition, k -> new DefinitionEntry((IDefinition)ObjectUtils.notNull((Object)k))));
    }

    @NonNull
    public Collection<DefinitionEntry> getDefinitions() {
        return (Collection)ObjectUtils.notNull(this.index.values());
    }

    private static class IndexVisitor
    extends ModelWalker<ModuleIndex> {
        @NonNull
        private final IInlineStrategy inlineStrategy;
        @NonNull
        private final ModuleIndex index;

        public IndexVisitor(@NonNull ModuleIndex index, @NonNull IInlineStrategy inlineStrategy) {
            this.index = index;
            this.inlineStrategy = inlineStrategy;
        }

        protected ModuleIndex getDefaultData() {
            return this.index;
        }

        protected boolean visit(IFlagInstance instance, ModuleIndex index) {
            this.handleInstance((INamedInstance)instance);
            return true;
        }

        protected boolean visit(IFieldInstance instance, ModuleIndex index) {
            this.handleInstance((INamedInstance)instance);
            return true;
        }

        protected boolean visit(IAssemblyInstance instance, ModuleIndex index) {
            this.handleInstance((INamedInstance)instance);
            return true;
        }

        protected void visit(IFlagDefinition def, ModuleIndex data) {
            this.handleDefinition((IDefinition)def);
        }

        protected boolean visit(IFieldDefinition def, ModuleIndex data) {
            return this.handleDefinition((IDefinition)def);
        }

        protected boolean visit(IAssemblyDefinition def, ModuleIndex data) {
            return this.handleDefinition((IDefinition)def);
        }

        private boolean handleDefinition(@NonNull IDefinition definition) {
            DefinitionEntry entry = this.getDefaultData().getEntry(definition);
            boolean visited = entry.isVisited();
            if (!visited) {
                entry.markVisited();
                if (this.inlineStrategy.isInline(definition, this.index)) {
                    entry.markInline();
                }
            }
            return !visited;
        }

        @NonNull
        private DefinitionEntry handleInstance(INamedInstance instance) {
            IDefinition definition = instance.getDefinition();
            DefinitionEntry entry = this.getDefaultData().getEntry(definition);
            entry.addReference(instance);
            if (IndexVisitor.isChoice(instance)) {
                entry.markUsedAsChoice();
            }
            if (IndexVisitor.isChoiceSibling(instance)) {
                entry.markAsChoiceSibling();
            }
            return entry;
        }

        private static boolean isChoice(@NonNull INamedInstance instance) {
            return instance.getParentContainer() instanceof IChoiceInstance;
        }

        private static boolean isChoiceSibling(@NonNull INamedInstance instance) {
            IModelDefinition containingDefinition = instance.getContainingDefinition();
            return containingDefinition instanceof IAssemblyDefinition && !((IAssemblyDefinition)containingDefinition).getChoiceInstances().isEmpty();
        }
    }

    public static class DefinitionEntry {
        @NonNull
        private final IDefinition definition;
        private final Set<INamedInstance> references = new HashSet<INamedInstance>();
        private final AtomicBoolean inline = new AtomicBoolean();
        private final AtomicBoolean visited = new AtomicBoolean();
        private final AtomicBoolean usedAsChoice = new AtomicBoolean();
        private final AtomicBoolean choiceSibling = new AtomicBoolean();

        public DefinitionEntry(@NonNull IDefinition definition) {
            this.definition = definition;
        }

        @NonNull
        public IDefinition getDefinition() {
            return this.definition;
        }

        public boolean isRoot() {
            return this.definition instanceof IAssemblyDefinition && ((IAssemblyDefinition)this.definition).isRoot();
        }

        public boolean isReferenced() {
            return !this.references.isEmpty() || this.isRoot();
        }

        public Set<INamedInstance> getReferences() {
            return this.references;
        }

        public boolean addReference(@NonNull INamedInstance reference) {
            return this.references.add(reference);
        }

        public void markVisited() {
            this.visited.compareAndSet(false, true);
        }

        public boolean isVisited() {
            return this.visited.get();
        }

        public void markInline() {
            this.inline.compareAndSet(false, true);
        }

        public boolean isInline() {
            return this.inline.get();
        }

        public void markUsedAsChoice() {
            this.usedAsChoice.compareAndSet(false, true);
        }

        public boolean isUsedAsChoice() {
            return this.usedAsChoice.get();
        }

        public void markAsChoiceSibling() {
            this.choiceSibling.compareAndSet(false, true);
        }

        public boolean isChoiceSibling() {
            return this.choiceSibling.get();
        }

        public boolean isUsedAsJsonKey() {
            return this.references.stream().anyMatch(ref -> ref instanceof INamedModelInstance && ((INamedModelInstance)ref).hasJsonKey());
        }

        public boolean isUsedWithoutJsonKey() {
            return this.definition instanceof IFlagDefinition || this.references.isEmpty() || this.references.stream().anyMatch(ref -> ref instanceof INamedModelInstance && !((INamedModelInstance)ref).hasJsonKey());
        }

        public boolean isChoiceGroupMember() {
            return this.references.stream().anyMatch(INamedModelInstanceGrouped.class::isInstance);
        }
    }
}

