/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen.json.impl;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.core.model.IDefinition;
import gov.nist.secauto.metaschema.core.model.IFlagInstance;
import gov.nist.secauto.metaschema.core.model.IModelDefinition;
import gov.nist.secauto.metaschema.core.qname.IEnhancedQName;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.schemagen.json.impl.AbstractJsonSchemaDefinition;
import gov.nist.secauto.metaschema.schemagen.json.impl.IJsonGenerationState;
import gov.nist.secauto.metaschema.schemagen.json.impl.IJsonSchemaDefinable;
import gov.nist.secauto.metaschema.schemagen.json.impl.IJsonSchemaDefinition;
import gov.nist.secauto.metaschema.schemagen.json.impl.IJsonSchemaDefinitionAssembly;
import gov.nist.secauto.metaschema.schemagen.json.impl.IJsonSchemaModelDefinition;
import gov.nist.secauto.metaschema.schemagen.json.impl.IJsonSchemaPropertyFlag;
import gov.nist.secauto.metaschema.schemagen.json.impl.JsonSchemaHelper;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;

public abstract class AbstractJsonSchemaModelDefinition<D extends IModelDefinition>
extends AbstractJsonSchemaDefinition<D>
implements IJsonSchemaModelDefinition {
    @Nullable
    private final IEnhancedQName jsonKeyFlagName;
    @NonNull
    private final List<IJsonSchemaPropertyFlag> flagProperties;

    public AbstractJsonSchemaModelDefinition(@NonNull D definition, @Nullable IEnhancedQName jsonKeyFlagName, @NonNull IJsonGenerationState state) {
        super(definition, state);
        this.jsonKeyFlagName = jsonKeyFlagName;
        this.flagProperties = JsonSchemaHelper.buildFlagProperties(definition, jsonKeyFlagName, state);
    }

    @Override
    public String generateDefinitionName(IJsonGenerationState state) {
        return state.generateJsonSchemaDefinitionName((IDefinition)this.getDefinition(), this.jsonKeyFlagName == null ? null : state.toFlagName(this.jsonKeyFlagName), null);
    }

    @Override
    public IFlagInstance getJsonKeyFlag() {
        return ((IModelDefinition)this.getDefinition()).getJsonKey();
    }

    @Override
    @Nullable
    public IEnhancedQName getJsonKeyFlagName() {
        return this.jsonKeyFlagName;
    }

    @Override
    public List<IJsonSchemaPropertyFlag> getFlagProperties() {
        return this.flagProperties;
    }

    @Override
    public Stream<IJsonSchemaDefinable> collectDefinitions(Set<IJsonSchemaDefinitionAssembly> visited, IJsonGenerationState state) {
        Stream<IJsonSchemaDefinition> retval = Stream.concat(Stream.of(this), this.getFlagProperties().stream().flatMap(property -> property.collectDefinitions(visited, state)));
        IFlagInstance jsonKeyFlag = this.getJsonKeyFlag();
        if (jsonKeyFlag != null) {
            retval = Stream.concat(retval, Stream.of(state.getFlagDefinition(jsonKeyFlag.getDefinition())));
        }
        return (Stream)ObjectUtils.notNull(retval);
    }
}

