/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen.json.impl;

import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.model.IDefinition;
import gov.nist.secauto.metaschema.core.model.IFlagInstance;
import gov.nist.secauto.metaschema.core.model.IModelDefinition;
import gov.nist.secauto.metaschema.core.model.INamedModelInstanceGrouped;
import gov.nist.secauto.metaschema.core.qname.IEnhancedQName;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.schemagen.json.impl.AbstractJsonSchemaProperty;
import gov.nist.secauto.metaschema.schemagen.json.impl.IJsonGenerationState;
import gov.nist.secauto.metaschema.schemagen.json.impl.IJsonSchemaDefinable;
import gov.nist.secauto.metaschema.schemagen.json.impl.IJsonSchemaDefinition;
import gov.nist.secauto.metaschema.schemagen.json.impl.IJsonSchemaDefinitionAssembly;
import gov.nist.secauto.metaschema.schemagen.json.impl.IJsonSchemaPropertyFlag;
import gov.nist.secauto.metaschema.schemagen.json.impl.IJsonSchemaPropertyGrouped;
import gov.nist.secauto.metaschema.schemagen.json.impl.IJsonSchemaPropertyNamed;
import gov.nist.secauto.metaschema.schemagen.json.impl.JsonSchemaHelper;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import nl.talsmasoftware.lazy4j.Lazy;

public abstract class AbstractJsonSchemaPropertyGrouped<I extends INamedModelInstanceGrouped>
extends AbstractJsonSchemaProperty<I>
implements IJsonSchemaPropertyGrouped {
    @NonNull
    private final Lazy<String> definitionName = (Lazy)ObjectUtils.notNull((Object)Lazy.lazy(() -> this.getDefinitionName(state)));
    @NonNull
    private final List<IJsonSchemaPropertyFlag> flagProperties;
    private final IFlagInstance jsonKey;

    protected AbstractJsonSchemaPropertyGrouped(@NonNull I instance, @NonNull IJsonGenerationState state) {
        super(instance);
        this.jsonKey = instance.getJsonKey();
        IEnhancedQName jsonKeyName = this.jsonKey == null ? null : this.jsonKey.getQName();
        this.flagProperties = JsonSchemaHelper.buildFlagProperties(instance.getDefinition(), jsonKeyName, state);
    }

    @Override
    public final List<IJsonSchemaPropertyFlag> getFlagProperties() {
        return this.flagProperties;
    }

    @Override
    public IFlagInstance getJsonKeyFlag() {
        return this.jsonKey;
    }

    @Override
    public String getDefinitionName() {
        return (String)ObjectUtils.notNull((Object)((String)this.definitionName.get()));
    }

    private String getDefinitionName(IJsonGenerationState state) {
        INamedModelInstanceGrouped instance = (INamedModelInstanceGrouped)this.getInstance();
        IModelDefinition definition = instance.getDefinition();
        String discriminatorProperty = instance.getParentContainer().getJsonDiscriminatorProperty();
        String discriminatorValue = instance.getEffectiveDisciminatorValue();
        IFlagInstance jsonKey = this.getJsonKeyFlag();
        return state.generateJsonSchemaDefinitionName((IDefinition)definition, jsonKey == null ? null : jsonKey.getEffectiveName(), (String)ObjectUtils.requireNonNull((Object)discriminatorProperty), (String)ObjectUtils.requireNonNull((Object)discriminatorValue), "Choice");
    }

    @Override
    public Stream<IJsonSchemaDefinable> collectDefinitions(Set<IJsonSchemaDefinitionAssembly> visited, IJsonGenerationState state) {
        Stream<IJsonSchemaDefinition> retval = Stream.concat(Stream.of(this), this.getFlagProperties().stream().flatMap(property -> property.collectDefinitions(visited, state)));
        IFlagInstance jsonKeyFlag = this.getJsonKeyFlag();
        if (jsonKeyFlag != null) {
            retval = Stream.concat(retval, Stream.of(state.getFlagDefinition(jsonKeyFlag.getDefinition())));
        }
        return (Stream)ObjectUtils.notNull(retval);
    }

    protected class DiscriminatorProperty
    implements IJsonSchemaPropertyNamed {
        protected DiscriminatorProperty() {
        }

        @Override
        public Stream<IJsonSchemaDefinable> collectDefinitions(Set<IJsonSchemaDefinitionAssembly> visited, IJsonGenerationState state) {
            return (Stream)ObjectUtils.notNull(Stream.empty());
        }

        @Override
        public void generate(ObjectNode node, IJsonGenerationState state) {
            node.put("const", ((INamedModelInstanceGrouped)AbstractJsonSchemaPropertyGrouped.this.getInstance()).getEffectiveDisciminatorValue());
        }

        @Override
        public String getName() {
            return ((INamedModelInstanceGrouped)AbstractJsonSchemaPropertyGrouped.this.getInstance()).getParentContainer().getJsonDiscriminatorProperty();
        }

        @Override
        public boolean isRequired() {
            return true;
        }
    }
}

