/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen.json.impl;

import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.model.IModelInstanceAbsolute;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.schemagen.json.impl.AbstractCardinalityBehavior;
import gov.nist.secauto.metaschema.schemagen.json.impl.IJsonGenerationState;
import gov.nist.secauto.metaschema.schemagen.json.impl.IJsonSchemaModelDefinition;
import java.util.Collection;

public final class CardinalityBehaviorArray
extends AbstractCardinalityBehavior {
    @NonNull
    private static final CardinalityBehaviorArray SINGLETON = new CardinalityBehaviorArray();

    @NonNull
    public static CardinalityBehaviorArray instance() {
        return SINGLETON;
    }

    private CardinalityBehaviorArray() {
    }

    @Override
    public void generate(ObjectNode node, IModelInstanceAbsolute instance, Collection<? extends IJsonSchemaModelDefinition> types, IJsonGenerationState state) {
        int minOccurs = instance.getMinOccurs();
        int maxOccurs = instance.getMaxOccurs();
        assert (minOccurs >= 0);
        assert (maxOccurs == -1 || maxOccurs >= 1);
        node.put("type", "array");
        ObjectNode items = (ObjectNode)ObjectUtils.notNull((Object)node.putObject("items"));
        this.generateInternal(items, types, state);
        assert (!items.isEmpty());
        node.put("minItems", Math.max(1, minOccurs));
        if (maxOccurs != -1) {
            node.put("maxItems", maxOccurs);
        }
    }
}

