/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen.json.impl;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.model.IFlagInstance;
import gov.nist.secauto.metaschema.core.model.IModelInstanceAbsolute;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.schemagen.json.impl.AbstractCardinalityBehavior;
import gov.nist.secauto.metaschema.schemagen.json.impl.IJsonGenerationState;
import gov.nist.secauto.metaschema.schemagen.json.impl.IJsonSchemaDefinition;
import gov.nist.secauto.metaschema.schemagen.json.impl.IJsonSchemaModelDefinition;
import java.util.Collection;

public final class CardinalityBehaviorKeyedObject
extends AbstractCardinalityBehavior {
    @NonNull
    private static final CardinalityBehaviorKeyedObject SINGLETON = new CardinalityBehaviorKeyedObject();

    @NonNull
    public static CardinalityBehaviorKeyedObject instance() {
        return SINGLETON;
    }

    private CardinalityBehaviorKeyedObject() {
    }

    @Override
    public void generate(ObjectNode node, IModelInstanceAbsolute instance, Collection<? extends IJsonSchemaModelDefinition> types, IJsonGenerationState state) {
        int minOccurs = instance.getMinOccurs();
        int maxOccurs = instance.getMaxOccurs();
        node.put("type", "object");
        if (minOccurs > 0) {
            node.put("minProperties", minOccurs);
        }
        if (maxOccurs != -1) {
            node.put("maxProperties", maxOccurs);
        }
        if (!types.isEmpty()) {
            if (types.size() == 1) {
                this.generatePropertyName(node, (IJsonSchemaModelDefinition)ObjectUtils.notNull((Object)types.iterator().next()), state);
            } else {
                ArrayNode anyOf = node.putArray("anyOf");
                for (IJsonSchemaModelDefinition iJsonSchemaModelDefinition : types) {
                    this.generatePropertyName((ObjectNode)ObjectUtils.notNull((Object)anyOf.objectNode()), (IJsonSchemaModelDefinition)ObjectUtils.notNull((Object)iJsonSchemaModelDefinition), state);
                }
            }
        }
    }

    private void generatePropertyName(@NonNull ObjectNode node, @NonNull IJsonSchemaModelDefinition type, @NonNull IJsonGenerationState state) {
        IFlagInstance flag = type.getJsonKeyFlag();
        if (flag != null) {
            IJsonSchemaDefinition flagSchema = state.getFlagDefinition(flag.getDefinition());
            ObjectNode propertyNames = (ObjectNode)ObjectUtils.notNull((Object)node.putObject("propertyNames"));
            flagSchema.generateJsonSchemaOrDefinitionRef(propertyNames, state);
        }
        ObjectNode patternProperties = (ObjectNode)ObjectUtils.notNull((Object)node.putObject("patternProperties"));
        ObjectNode wildcard = (ObjectNode)ObjectUtils.notNull((Object)patternProperties.putObject("^.*$"));
        this.generateInternal(wildcard, CollectionUtil.singleton((Object)type), state);
    }
}

