/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen.json.impl;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.model.IModelInstanceAbsolute;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.schemagen.json.impl.AbstractCardinalityBehavior;
import gov.nist.secauto.metaschema.schemagen.json.impl.IJsonGenerationState;
import gov.nist.secauto.metaschema.schemagen.json.impl.IJsonSchemaDefinable;
import gov.nist.secauto.metaschema.schemagen.json.impl.IJsonSchemaModelDefinition;
import java.util.Collection;

public final class CardinalityBehaviorSingletonOrList
extends AbstractCardinalityBehavior {
    @NonNull
    private static final CardinalityBehaviorSingletonOrList SINGLETON = new CardinalityBehaviorSingletonOrList();

    @NonNull
    public static CardinalityBehaviorSingletonOrList instance() {
        return SINGLETON;
    }

    private CardinalityBehaviorSingletonOrList() {
    }

    @Override
    public void generate(ObjectNode node, IModelInstanceAbsolute instance, Collection<? extends IJsonSchemaModelDefinition> types, IJsonGenerationState state) {
        ArrayNode oneOf = node.putArray("oneOf");
        this.generateInternal((ObjectNode)ObjectUtils.notNull((Object)oneOf.addObject()), types, state);
        this.generateArray((ObjectNode)ObjectUtils.notNull((Object)oneOf.addObject()), instance, types, state);
    }

    private void generateArray(@NonNull ObjectNode node, @NonNull IModelInstanceAbsolute instance, @NonNull Collection<? extends IJsonSchemaDefinable> types, @NonNull IJsonGenerationState state) {
        int minOccurs = instance.getMinOccurs();
        int maxOccurs = instance.getMaxOccurs();
        assert (minOccurs >= 0);
        assert (maxOccurs == -1 || maxOccurs >= 1);
        node.put("type", "array");
        ObjectNode items = (ObjectNode)ObjectUtils.notNull((Object)node.putObject("items"));
        this.generateInternal(items, types, state);
        assert (!items.isEmpty());
        node.put("minItems", Math.max(2, minOccurs));
        if (maxOccurs != -1) {
            node.put("maxItems", maxOccurs);
        }
    }
}

