/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen.json.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.datatype.IDataTypeAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.DecimalAdapter;
import gov.nist.secauto.metaschema.core.model.IDefinition;
import gov.nist.secauto.metaschema.core.model.IValuedDefinition;
import gov.nist.secauto.metaschema.core.model.constraint.IAllowedValue;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.schemagen.AbstractGenerationState;
import gov.nist.secauto.metaschema.schemagen.json.impl.IDataTypeJsonSchema;
import gov.nist.secauto.metaschema.schemagen.json.impl.IJsonGenerationState;
import gov.nist.secauto.metaschema.schemagen.json.impl.IJsonSchemaDefinable;
import gov.nist.secauto.metaschema.schemagen.json.impl.IJsonSchemaDefinitionAssembly;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Set;
import java.util.stream.Stream;

public class DataTypeRestrictionDefinitionJsonSchema
implements IDataTypeJsonSchema {
    @NonNull
    private final String name;
    @NonNull
    private final IDataTypeAdapter<?> dataTypeAdapter;
    @NonNull
    private final AbstractGenerationState.AllowedValueCollection allowedValuesCollection;

    public DataTypeRestrictionDefinitionJsonSchema(@NonNull IValuedDefinition definition, @NonNull AbstractGenerationState.AllowedValueCollection allowedValuesCollection, @NonNull IJsonGenerationState state) {
        this.name = state.generateJsonSchemaDefinitionName((IDefinition)definition, null, "Value");
        this.dataTypeAdapter = definition.getJavaTypeAdapter();
        CollectionUtil.requireNonEmpty(allowedValuesCollection.getValues());
        this.allowedValuesCollection = allowedValuesCollection;
    }

    @Override
    public IDataTypeAdapter<?> getDataTypeAdapter() {
        return this.dataTypeAdapter;
    }

    @Override
    public boolean isInline(IJsonGenerationState state) {
        return true;
    }

    @Override
    public Stream<IJsonSchemaDefinable> collectDefinitions(Set<IJsonSchemaDefinitionAssembly> visited, IJsonGenerationState state) {
        state.getSchema(this.getDataTypeAdapter());
        return (Stream)ObjectUtils.notNull(Stream.of(this));
    }

    @Override
    public String getDefinitionName() {
        return this.name;
    }

    @Override
    public void generateDefinitionJsonSchema(ObjectNode node, IJsonGenerationState state) {
        throw new UnsupportedOperationException("not used");
    }

    @Override
    public void generateInlineJsonSchema(ObjectNode node, IJsonGenerationState state) {
        ArrayNode enumArray = this.generateEnumArray();
        IDataTypeJsonSchema dataTypeSchema = state.getSchema(this.getDataTypeAdapter());
        ArrayNode ofArray = this.allowedValuesCollection.isClosed() ? node.putArray("allOf") : node.putArray("anyOf");
        dataTypeSchema.generateJsonSchemaOrDefinitionRef((ObjectNode)ObjectUtils.notNull((Object)ofArray.addObject()), state);
        ofArray.addObject().set("enum", (JsonNode)enumArray);
    }

    @NonNull
    private ArrayNode generateEnumArray() {
        ArrayNode enumArray = JsonNodeFactory.instance.arrayNode();
        for (IAllowedValue allowedValue : this.allowedValuesCollection.getValues()) {
            switch (this.getDataTypeAdapter().getJsonRawType()) {
                case STRING: {
                    enumArray.add(allowedValue.getValue());
                    break;
                }
                case BOOLEAN: {
                    enumArray.add(Boolean.parseBoolean(allowedValue.getValue()));
                    break;
                }
                case INTEGER: {
                    enumArray.add(new BigInteger(allowedValue.getValue()));
                    break;
                }
                case NUMBER: {
                    enumArray.add(new BigDecimal(allowedValue.getValue(), DecimalAdapter.mathContext()));
                    break;
                }
                case ANY: 
                case ARRAY: 
                case NULL: 
                case OBJECT: {
                    throw new UnsupportedOperationException(this.getDataTypeAdapter().getJsonRawType().toString());
                }
            }
        }
        return (ArrayNode)ObjectUtils.notNull((Object)enumArray);
    }
}

