/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen.json.impl;

import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.model.IModelInstanceAbsolute;
import gov.nist.secauto.metaschema.schemagen.json.impl.AbstractCardinalityBehavior;
import gov.nist.secauto.metaschema.schemagen.json.impl.CardinalityBehaviorArray;
import gov.nist.secauto.metaschema.schemagen.json.impl.CardinalityBehaviorKeyedObject;
import gov.nist.secauto.metaschema.schemagen.json.impl.CardinalityBehaviorSingleton;
import gov.nist.secauto.metaschema.schemagen.json.impl.CardinalityBehaviorSingletonOrList;
import gov.nist.secauto.metaschema.schemagen.json.impl.IJsonGenerationState;
import gov.nist.secauto.metaschema.schemagen.json.impl.IJsonSchemaModelDefinition;
import java.util.Collection;

public interface ICardinalityBehavior {
    @NonNull
    public static ICardinalityBehavior behaviorFor(@NonNull IModelInstanceAbsolute instance) {
        int maxOccurs = instance.getMaxOccurs();
        AbstractCardinalityBehavior retval = null;
        if (maxOccurs == -1 || maxOccurs > 1) {
            switch (instance.getJsonGroupAsBehavior()) {
                case KEYED: {
                    retval = CardinalityBehaviorKeyedObject.instance();
                    break;
                }
                case LIST: {
                    retval = CardinalityBehaviorArray.instance();
                    break;
                }
                case SINGLETON_OR_LIST: {
                    retval = CardinalityBehaviorSingletonOrList.instance();
                    break;
                }
                case NONE: {
                    retval = CardinalityBehaviorSingleton.instance();
                }
            }
            if (!2.$assertionsDisabled && retval == null) {
                throw new AssertionError((Object)String.format("Unsupported group-as in-json binding '%s'.", instance.getJsonGroupAsBehavior()));
            }
        } else {
            retval = CardinalityBehaviorSingleton.instance();
        }
        return retval;
    }

    public void generate(@NonNull ObjectNode var1, @NonNull IModelInstanceAbsolute var2, @NonNull Collection<? extends IJsonSchemaModelDefinition> var3, @NonNull IJsonGenerationState var4);

    static {
        if (2.$assertionsDisabled) {
            // empty if block
        }
    }
}

