/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen.json.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.model.xml.ModuleLoader;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.schemagen.SchemaGenerationException;
import gov.nist.secauto.metaschema.schemagen.datatype.AbstractDatatypeManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class JsonDatatypeManager
extends AbstractDatatypeManager {
    private static final Map<String, List<String>> DATATYPE_DEPENDENCY_MAP;
    private static final Pattern DEFINITION_REF_PATTERN;
    private static final Map<String, JsonNode> JSON_DATATYPES;

    private static Stream<String> getDependencies(@NonNull JsonNode node) {
        Stream<String> retval = Stream.empty();
        for (Map.Entry entry : CollectionUtil.toIterable((Iterator)((Iterator)ObjectUtils.notNull((Object)node.fields())))) {
            Matcher matcher;
            JsonNode value = (JsonNode)entry.getValue();
            assert (value != null);
            if ("$ref".equals(entry.getKey()) && (matcher = DEFINITION_REF_PATTERN.matcher(value.asText())).matches()) {
                String dependency = matcher.group(1);
                retval = Stream.concat(retval, Stream.of(dependency));
            }
            if (!value.isArray()) continue;
            for (JsonNode child : CollectionUtil.toIterable((Iterator)((Iterator)ObjectUtils.notNull((Object)value.elements())))) {
                assert (child != null);
                retval = Stream.concat(retval, JsonDatatypeManager.getDependencies(child));
            }
        }
        return retval;
    }

    public void generateDatatypeDefinitions(@NonNull ObjectNode definitionsObject) {
        Set<String> requiredJsonDatatypes = this.getUsedTypes();
        for (String datatype2 : CollectionUtil.toIterable((Iterator)((Iterator)ObjectUtils.notNull(requiredJsonDatatypes.stream().flatMap(datatype -> {
            List<String> dependencies = DATATYPE_DEPENDENCY_MAP.get(datatype);
            Stream<String> result = dependencies == null ? Stream.of(datatype) : Stream.concat(Stream.of(datatype), dependencies.stream());
            return result;
        }).distinct().sorted().iterator())))) {
            JsonNode definition = JSON_DATATYPES.get(datatype2);
            if (definition == null) {
                throw new SchemaGenerationException("Missing JSON datatype definition for: /definitions/" + datatype2);
            }
            definitionsObject.set(datatype2, definition);
        }
    }

    static {
        JsonNode jsonData;
        DATATYPE_DEPENDENCY_MAP = new ConcurrentHashMap<String, List<String>>();
        DEFINITION_REF_PATTERN = Pattern.compile("^#/definitions/(.+)$");
        JSON_DATATYPES = new ConcurrentHashMap<String, JsonNode>();
        try (InputStream is = ModuleLoader.class.getResourceAsStream("/schema/json/metaschema-datatypes.json");){
            ObjectMapper objectMapper = new ObjectMapper();
            jsonData = objectMapper.readTree(is);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        for (String ref : JsonDatatypeManager.getDatatypeTranslationMap().values()) {
            JsonNode refNode = jsonData.at("/definitions/" + ref);
            if (refNode.isMissingNode()) continue;
            JSON_DATATYPES.put(ref, refNode);
            List dependencies = JsonDatatypeManager.getDependencies(refNode).collect(Collectors.toList());
            if (dependencies.isEmpty()) continue;
            DATATYPE_DEPENDENCY_MAP.put(ref, dependencies);
        }
    }
}

