/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen.json.impl;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.core.configuration.IConfiguration;
import gov.nist.secauto.metaschema.core.datatype.IDataTypeAdapter;
import gov.nist.secauto.metaschema.core.model.IAssemblyDefinition;
import gov.nist.secauto.metaschema.core.model.IAssemblyInstanceAbsolute;
import gov.nist.secauto.metaschema.core.model.IAssemblyInstanceGrouped;
import gov.nist.secauto.metaschema.core.model.IChoiceGroupInstance;
import gov.nist.secauto.metaschema.core.model.IDefinition;
import gov.nist.secauto.metaschema.core.model.IFieldDefinition;
import gov.nist.secauto.metaschema.core.model.IFieldInstanceAbsolute;
import gov.nist.secauto.metaschema.core.model.IFieldInstanceGrouped;
import gov.nist.secauto.metaschema.core.model.IFlagDefinition;
import gov.nist.secauto.metaschema.core.model.IFlagInstance;
import gov.nist.secauto.metaschema.core.model.IModelDefinition;
import gov.nist.secauto.metaschema.core.model.IModelInstanceAbsolute;
import gov.nist.secauto.metaschema.core.model.IModule;
import gov.nist.secauto.metaschema.core.model.INamedModelInstanceGrouped;
import gov.nist.secauto.metaschema.core.model.IValuedDefinition;
import gov.nist.secauto.metaschema.core.model.constraint.IAllowedValue;
import gov.nist.secauto.metaschema.core.qname.IEnhancedQName;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.schemagen.AbstractGenerationState;
import gov.nist.secauto.metaschema.schemagen.IGenerationState;
import gov.nist.secauto.metaschema.schemagen.SchemaGenerationFeature;
import gov.nist.secauto.metaschema.schemagen.json.impl.AbstractJsonSchemaPropertyGrouped;
import gov.nist.secauto.metaschema.schemagen.json.impl.AbstractJsonSchemaPropertyNamed;
import gov.nist.secauto.metaschema.schemagen.json.impl.DataTypeJsonSchema;
import gov.nist.secauto.metaschema.schemagen.json.impl.DataTypeRestrictionDefinitionJsonSchema;
import gov.nist.secauto.metaschema.schemagen.json.impl.IDataTypeJsonSchema;
import gov.nist.secauto.metaschema.schemagen.json.impl.IJsonGenerationState;
import gov.nist.secauto.metaschema.schemagen.json.impl.IJsonSchemaDefinable;
import gov.nist.secauto.metaschema.schemagen.json.impl.IJsonSchemaDefinition;
import gov.nist.secauto.metaschema.schemagen.json.impl.IJsonSchemaDefinitionAssembly;
import gov.nist.secauto.metaschema.schemagen.json.impl.IJsonSchemaDefinitionField;
import gov.nist.secauto.metaschema.schemagen.json.impl.IJsonSchemaPropertyFlag;
import gov.nist.secauto.metaschema.schemagen.json.impl.IJsonSchemaPropertyGrouped;
import gov.nist.secauto.metaschema.schemagen.json.impl.IJsonSchemaPropertyNamed;
import gov.nist.secauto.metaschema.schemagen.json.impl.JsonDatatypeManager;
import gov.nist.secauto.metaschema.schemagen.json.impl.JsonSchemaDefinitionAssembly;
import gov.nist.secauto.metaschema.schemagen.json.impl.JsonSchemaDefinitionField;
import gov.nist.secauto.metaschema.schemagen.json.impl.JsonSchemaDefinitionFlag;
import gov.nist.secauto.metaschema.schemagen.json.impl.JsonSchemaPropertyAssembly;
import gov.nist.secauto.metaschema.schemagen.json.impl.JsonSchemaPropertyChoiceGroup;
import gov.nist.secauto.metaschema.schemagen.json.impl.JsonSchemaPropertyField;
import gov.nist.secauto.metaschema.schemagen.json.impl.JsonSchemaPropertyFlag;
import gov.nist.secauto.metaschema.schemagen.json.impl.JsonSchemaPropertyGroupedAssembly;
import gov.nist.secauto.metaschema.schemagen.json.impl.JsonSchemaPropertyGroupedField;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public class JsonGenerationState
extends AbstractGenerationState<JsonGenerator, JsonDatatypeManager>
implements IJsonGenerationState {
    @NonNull
    private final JsonNodeFactory jsonNodeFactory = new JsonNodeFactory(true);
    @NonNull
    private final Map<IValuedDefinition, IDataTypeJsonSchema> definitionValueToDataTypeSchemaMap = new ConcurrentHashMap<IValuedDefinition, IDataTypeJsonSchema>();
    @NonNull
    private final Map<IDataTypeAdapter<?>, IDataTypeJsonSchema> dataTypeToSchemaMap = new ConcurrentHashMap();
    @NonNull
    private final Map<String, IJsonSchemaDefinable> definitionNameToJsonSchemaMap = new ConcurrentHashMap<String, IJsonSchemaDefinable>();
    @NonNull
    private final Map<IDefinition, Map<IEnhancedQName, IJsonSchemaDefinition>> definitionToJsonKeyToJsonSchemaMap = new ConcurrentHashMap<IDefinition, Map<IEnhancedQName, IJsonSchemaDefinition>>();
    @NonNull
    private final Map<GroupedDefinition, Map<IEnhancedQName, IJsonSchemaPropertyGrouped>> groupedInstanceToJsonKeyToJsonSchemaMap = new ConcurrentHashMap<GroupedDefinition, Map<IEnhancedQName, IJsonSchemaPropertyGrouped>>();

    public JsonGenerationState(@NonNull IModule module, @NonNull JsonGenerator writer, @NonNull IConfiguration<SchemaGenerationFeature<?>> configuration) {
        super(module, writer, configuration, new JsonDatatypeManager());
    }

    @NonNull
    private <T extends IJsonSchemaDefinition> T addToCache(@NonNull IDefinition definition, @Nullable IEnhancedQName jsonKeyName, @NonNull Supplier<T> supplier) {
        Map jsonKeyMap = this.definitionToJsonKeyToJsonSchemaMap.computeIfAbsent(definition, key -> new LinkedHashMap());
        IJsonSchemaDefinition retval = jsonKeyMap.computeIfAbsent(jsonKeyName, key -> (IJsonSchemaDefinition)supplier.get());
        assert (definition.equals(retval.getDefinition()));
        if (!this.isInline(definition)) {
            IJsonSchemaDefinable newSchema = this.definitionNameToJsonSchemaMap.computeIfAbsent(retval.getDefinitionName(), key -> retval);
            assert (newSchema.equals(retval)) : "Duplicate JSON definition name: " + retval.getDefinitionName();
        }
        return (T)retval;
    }

    @NonNull
    private <T extends IJsonSchemaPropertyGrouped> T addToCache(@NonNull INamedModelInstanceGrouped instance, @Nullable IEnhancedQName jsonKeyName, @NonNull Supplier<T> supplier) {
        GroupedDefinition grouped = new GroupedDefinition(instance);
        Map jsonKeyMap = this.groupedInstanceToJsonKeyToJsonSchemaMap.computeIfAbsent(grouped, key -> new LinkedHashMap());
        IJsonSchemaPropertyGrouped retval = jsonKeyMap.computeIfAbsent(jsonKeyName, key -> (IJsonSchemaPropertyGrouped)supplier.get());
        assert (grouped.equals(new GroupedDefinition(retval.getInstance())));
        if (!this.isInline((IDefinition)instance.getDefinition())) {
            IJsonSchemaDefinable newSchema = this.definitionNameToJsonSchemaMap.computeIfAbsent(retval.getDefinitionName(), key -> retval);
            assert (newSchema.equals(retval)) : "Duplicate JSON definition name: " + retval.getDefinitionName();
        }
        return (T)retval;
    }

    @Override
    public IJsonSchemaDefinitionAssembly getAssemblyDefinition(IAssemblyDefinition definition, IEnhancedQName jsonKeyName) {
        return this.addToCache((IDefinition)definition, jsonKeyName, () -> new JsonSchemaDefinitionAssembly(definition, jsonKeyName, (IJsonGenerationState)this));
    }

    @Override
    public IJsonSchemaDefinitionField getFieldDefinition(IFieldDefinition definition, IEnhancedQName jsonKeyName) {
        return this.addToCache((IDefinition)definition, jsonKeyName, () -> new JsonSchemaDefinitionField(definition, jsonKeyName, (IJsonGenerationState)this));
    }

    @Override
    public IJsonSchemaDefinition getFlagDefinition(IFlagDefinition definition) {
        return this.addToCache((IDefinition)definition, null, () -> new JsonSchemaDefinitionFlag(definition, (IJsonGenerationState)this));
    }

    @Override
    public IJsonSchemaPropertyFlag getJsonSchemaPropertyFlag(IFlagInstance instance) {
        return new JsonSchemaPropertyFlag(instance, this);
    }

    @Override
    public IJsonSchemaPropertyNamed getJsonSchemaPropertyModel(@NonNull IModelInstanceAbsolute instance) {
        AbstractJsonSchemaPropertyNamed retval;
        if (instance instanceof IAssemblyInstanceAbsolute) {
            retval = new JsonSchemaPropertyAssembly((IAssemblyInstanceAbsolute)instance, this);
        } else if (instance instanceof IFieldInstanceAbsolute) {
            retval = new JsonSchemaPropertyField((IFieldInstanceAbsolute)instance, this);
        } else if (instance instanceof IChoiceGroupInstance) {
            retval = new JsonSchemaPropertyChoiceGroup((IChoiceGroupInstance)instance, this);
        } else {
            throw new UnsupportedOperationException("Unsupported property type: " + String.valueOf(instance.getClass()));
        }
        return retval;
    }

    @Override
    public IJsonSchemaPropertyGrouped getJsonSchemaPropertyGrouped(INamedModelInstanceGrouped instance) {
        return this.addToCache(instance, null, () -> this.newJsonSchemaPropertyGrouped(instance));
    }

    private IJsonSchemaPropertyGrouped newJsonSchemaPropertyGrouped(INamedModelInstanceGrouped instance) {
        AbstractJsonSchemaPropertyGrouped retval;
        if (instance instanceof IAssemblyInstanceGrouped) {
            retval = new JsonSchemaPropertyGroupedAssembly((IAssemblyInstanceGrouped)instance, (IJsonGenerationState)this);
        } else if (instance instanceof IFieldInstanceGrouped) {
            retval = new JsonSchemaPropertyGroupedField((IFieldInstanceGrouped)instance, (IJsonGenerationState)this);
        } else {
            throw new UnsupportedOperationException("Unsupported property type: " + String.valueOf(instance.getClass()));
        }
        return retval;
    }

    @Override
    @NonNull
    public IDataTypeJsonSchema getSchema(@NonNull IDataTypeAdapter<?> datatype) {
        IDataTypeJsonSchema retval = this.dataTypeToSchemaMap.get(datatype);
        if (retval == null) {
            retval = new DataTypeJsonSchema(((JsonDatatypeManager)this.getDatatypeManager()).getTypeNameForDatatype(datatype), datatype);
            this.dataTypeToSchemaMap.put(datatype, retval);
        }
        return retval;
    }

    @Override
    public void generateDataTypeDefinitions(@NonNull ObjectNode definitionsNode) {
        ((JsonDatatypeManager)this.getDatatypeManager()).generateDatatypeDefinitions(definitionsNode);
    }

    @Override
    public JsonNodeFactory getJsonNodeFactory() {
        return this.jsonNodeFactory;
    }

    @Override
    @NonNull
    public IDataTypeJsonSchema getDataTypeSchemaForDefinition(@NonNull IValuedDefinition definition) {
        IDataTypeJsonSchema retval = this.definitionValueToDataTypeSchemaMap.get(definition);
        if (retval == null) {
            AbstractGenerationState.AllowedValueCollection allowedValuesCollection = JsonGenerationState.getContextIndependentEnumeratedValues(definition);
            List<IAllowedValue> allowedValues = allowedValuesCollection.getValues();
            IDataTypeAdapter dataTypeAdapter = definition.getJavaTypeAdapter();
            retval = this.getSchema(dataTypeAdapter);
            if (!allowedValues.isEmpty()) {
                retval = new DataTypeRestrictionDefinitionJsonSchema(definition, allowedValuesCollection, this);
            }
            this.definitionValueToDataTypeSchemaMap.put(definition, retval);
        }
        return retval;
    }

    @Override
    public String generateJsonSchemaDefinitionName(@NonNull IDefinition definition, @Nullable String jsonKeyFlagName, @Nullable String discriminatorProperty, @Nullable String discriminatorValue, @Nullable String suffix) {
        StringBuilder builder = new StringBuilder();
        if (jsonKeyFlagName != null) {
            builder.append(IGenerationState.toCamelCase(jsonKeyFlagName)).append("JsonKey");
        }
        if (discriminatorProperty != null || discriminatorValue != null) {
            builder.append(IGenerationState.toCamelCase((String)ObjectUtils.requireNonNull((Object)discriminatorProperty))).append(IGenerationState.toCamelCase((String)ObjectUtils.requireNonNull((Object)discriminatorValue))).append("Choice");
        }
        if (suffix != null) {
            builder.append(suffix);
        }
        return this.getTypeNameForDefinition(definition, builder.toString());
    }

    public void writeObject(ObjectNode schemaNode) throws IOException {
        ((JsonGenerator)this.getWriter()).writeObject((Object)schemaNode);
    }

    public void writeStartObject() throws IOException {
        ((JsonGenerator)this.getWriter()).writeStartObject();
    }

    public void writeEndObject() throws IOException {
        ((JsonGenerator)this.getWriter()).writeEndObject();
    }

    public void writeField(String fieldName, String value) throws IOException {
        ((JsonGenerator)this.getWriter()).writeStringField(fieldName, value);
    }

    public void writeField(String fieldName, ObjectNode obj) throws IOException {
        JsonGenerator writer = (JsonGenerator)this.getWriter();
        writer.writeFieldName(fieldName);
        writer.writeTree((TreeNode)obj);
    }

    @Override
    public void flushWriter() throws IOException {
        ((JsonGenerator)this.getWriter()).flush();
    }

    private static class GroupedDefinition {
        private final IModelDefinition definition;
        private final String disciminatorProperty;
        private final String disciminatorValue;

        public GroupedDefinition(@NonNull INamedModelInstanceGrouped instance) {
            this.definition = instance.getDefinition();
            this.disciminatorProperty = instance.getParentContainer().getJsonDiscriminatorProperty();
            this.disciminatorValue = instance.getEffectiveDisciminatorValue();
        }

        public int hashCode() {
            return Objects.hash(this.definition, this.disciminatorProperty, this.disciminatorValue);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GroupedDefinition other = (GroupedDefinition)obj;
            return Objects.equals(this.definition, other.definition) && Objects.equals(this.disciminatorProperty, other.disciminatorProperty) && Objects.equals(this.disciminatorValue, other.disciminatorValue);
        }
    }
}

