/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen.json.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BigIntegerNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DecimalNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.core.datatype.IDataTypeAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.core.metapath.StaticMetapathException;
import gov.nist.secauto.metaschema.core.model.IChoiceInstance;
import gov.nist.secauto.metaschema.core.model.IContainerModelAbsolute;
import gov.nist.secauto.metaschema.core.model.IFlagInstance;
import gov.nist.secauto.metaschema.core.model.IModelDefinition;
import gov.nist.secauto.metaschema.core.model.IModelElement;
import gov.nist.secauto.metaschema.core.model.IModelInstanceAbsolute;
import gov.nist.secauto.metaschema.core.model.INamedModelElement;
import gov.nist.secauto.metaschema.core.model.IValuedDefinition;
import gov.nist.secauto.metaschema.core.model.IValuedInstance;
import gov.nist.secauto.metaschema.core.qname.IEnhancedQName;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.schemagen.json.impl.IJsonGenerationState;
import gov.nist.secauto.metaschema.schemagen.json.impl.IJsonSchemaDefinable;
import gov.nist.secauto.metaschema.schemagen.json.impl.IJsonSchemaDefinitionAssembly;
import gov.nist.secauto.metaschema.schemagen.json.impl.IJsonSchemaDefinitionField;
import gov.nist.secauto.metaschema.schemagen.json.impl.IJsonSchemaPropertyFlag;
import gov.nist.secauto.metaschema.schemagen.json.impl.IJsonSchemaPropertyNamed;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class JsonSchemaHelper {
    public static final Comparator<IJsonSchemaPropertyNamed> INSTANCE_NAME_COMPARATOR = Comparator.comparing(IJsonSchemaPropertyNamed::getName);
    public static final Comparator<IJsonSchemaDefinable> DEFINABLE_NAME_COMPARATOR = Comparator.comparing(IJsonSchemaDefinable::getDefinitionName);

    public static void generateTitle(@NonNull INamedModelElement named, @NonNull ObjectNode obj) {
        String formalName = named.getEffectiveFormalName();
        if (formalName != null) {
            obj.put("title", formalName);
        }
    }

    public static <NAMED extends INamedModelElement & IModelElement> void generateDescription(@NonNull NAMED named, @NonNull ObjectNode obj) {
        MarkupMultiline remarks;
        MarkupLine description = named.getEffectiveDescription();
        StringBuilder retval = null;
        if (description != null) {
            retval = new StringBuilder().append(description.toMarkdown());
        }
        if ((remarks = named.getRemarks()) != null) {
            if (retval == null) {
                retval = new StringBuilder();
            } else {
                retval.append("\n\n");
            }
            retval.append(remarks.toMarkdown());
        }
        if (retval != null) {
            obj.put("description", retval.toString());
        }
    }

    public static void generateDefault(@NonNull IValuedInstance instance, @NonNull ObjectNode obj) {
        Object defaultValue = instance.getEffectiveDefaultValue();
        if (defaultValue != null) {
            IValuedDefinition definition = instance.getDefinition();
            IDataTypeAdapter adapter = definition.getJavaTypeAdapter();
            obj.set("default", JsonSchemaHelper.toJsonValue(defaultValue, adapter));
        }
    }

    private static JsonNode toJsonValue(@Nullable Object defaultValue, @NonNull IDataTypeAdapter<?> adapter) {
        BigIntegerNode retval = null;
        switch (adapter.getJsonRawType()) {
            case BOOLEAN: {
                if (!(defaultValue instanceof Boolean)) break;
                retval = BooleanNode.valueOf((boolean)((Boolean)defaultValue));
                break;
            }
            case INTEGER: {
                if (defaultValue instanceof BigInteger) {
                    retval = BigIntegerNode.valueOf((BigInteger)((BigInteger)defaultValue));
                    break;
                }
                if (defaultValue instanceof Integer) {
                    retval = IntNode.valueOf((int)((Integer)defaultValue));
                    break;
                }
                if (!(defaultValue instanceof Long)) break;
                retval = LongNode.valueOf((long)((Long)defaultValue));
                break;
            }
            case NUMBER: {
                if (defaultValue instanceof BigDecimal) {
                    retval = DecimalNode.valueOf((BigDecimal)((BigDecimal)defaultValue));
                    break;
                }
                if (!(defaultValue instanceof Double)) break;
                retval = DoubleNode.valueOf((double)((Double)defaultValue));
                break;
            }
            case ANY: 
            case ARRAY: 
            case OBJECT: 
            case NULL: {
                throw new UnsupportedOperationException("Invalid type: " + String.valueOf(adapter.getClass()));
            }
        }
        if (retval == null && defaultValue != null) {
            retval = TextNode.valueOf((String)adapter.asString(defaultValue));
        }
        return retval;
    }

    @NonNull
    public static String generateDefinitionJsonPointer(@NonNull IJsonSchemaDefinable schema) {
        return (String)ObjectUtils.notNull((Object)("#/definitions/" + schema.getDefinitionName()));
    }

    public static void generateProperties(@NonNull Collection<IJsonSchemaPropertyNamed> properties, @NonNull ObjectNode node, @NonNull IJsonGenerationState state) {
        if (!properties.isEmpty()) {
            ObjectNode propertiesNode = node.putObject("properties");
            LinkedList required = new LinkedList();
            properties.forEach(property -> {
                ObjectNode propertyNode = (ObjectNode)ObjectUtils.notNull((Object)state.getJsonNodeFactory().objectNode());
                property.generate(propertyNode, state);
                String name = property.getName();
                propertiesNode.set(name, (JsonNode)propertyNode);
                if (property.isRequired()) {
                    required.add(name);
                }
            });
            if (!required.isEmpty()) {
                ArrayNode requiredNode = node.putArray("required");
                required.forEach(arg_0 -> ((ArrayNode)requiredNode).add(arg_0));
            }
        }
    }

    @NonNull
    public static List<IJsonSchemaPropertyFlag> buildFlagProperties(@NonNull IModelDefinition definition, @Nullable IEnhancedQName jsonKeyFlagName, @NonNull IJsonGenerationState state) {
        Stream<Object> flagStream = definition.getFlagInstances().stream();
        if (jsonKeyFlagName != null) {
            IFlagInstance jsonKeyFlag;
            try {
                jsonKeyFlag = definition.getFlagInstanceByName(Integer.valueOf(jsonKeyFlagName.getIndexPosition()));
            }
            catch (StaticMetapathException ex) {
                throw new IllegalArgumentException(ex);
            }
            if (jsonKeyFlag == null) {
                throw new IllegalArgumentException(String.format("The referenced json-key flag-name '%s' does not exist on definition '%s'.", jsonKeyFlagName, definition.getName()));
            }
            flagStream = flagStream.filter(instance -> !jsonKeyFlag.equals(instance));
        }
        return (List)ObjectUtils.notNull(flagStream.map(instance -> state.getJsonSchemaPropertyFlag((IFlagInstance)ObjectUtils.requireNonNull((Object)instance))).collect(Collectors.toUnmodifiableList()));
    }

    @NonNull
    public static List<IJsonSchemaPropertyNamed> buildModelProperties(@NonNull IContainerModelAbsolute definition, @NonNull IJsonGenerationState state) {
        return (List)ObjectUtils.notNull(definition.getModelInstances().stream().filter(instance -> !(instance instanceof IChoiceInstance)).map(instance -> state.getJsonSchemaPropertyModel((IModelInstanceAbsolute)ObjectUtils.notNull((Object)instance))).collect(Collectors.toUnmodifiableList()));
    }

    public static void generateFieldBody(@NonNull IJsonSchemaDefinitionField field, @NonNull ObjectNode node, @NonNull IJsonGenerationState state) {
        if (field.getNonValueProperties().isEmpty()) {
            field.getFieldValue().generateJsonSchemaOrDefinitionRef(node, state);
        } else {
            JsonSchemaHelper.generateComplexFieldBody(field, node, state);
        }
    }

    private static void generateComplexFieldBody(@NonNull IJsonSchemaDefinitionField field, @NonNull ObjectNode node, @NonNull IJsonGenerationState state) {
        List<? extends IJsonSchemaPropertyNamed> nonValueProperties = field.getNonValueProperties();
        node.put("type", "object");
        IFlagInstance jsonValueKeyFlag = field.getDefinition().getJsonValueKeyFlagInstance();
        Stream<Object> propertiesStream = nonValueProperties.stream();
        propertiesStream = jsonValueKeyFlag == null ? Stream.concat(propertiesStream, Stream.of(new FieldValueProperty(field))) : propertiesStream.filter(property -> !(property instanceof IJsonSchemaPropertyFlag) || !jsonValueKeyFlag.equals(((IJsonSchemaPropertyFlag)property).getInstance()));
        List properties = (List)ObjectUtils.notNull(propertiesStream.sorted(INSTANCE_NAME_COMPARATOR).collect(Collectors.toUnmodifiableList()));
        JsonSchemaHelper.generateProperties(properties, node, state);
        if (jsonValueKeyFlag == null) {
            node.put("additionalProperties", false);
        } else {
            ObjectNode additionalPropertiesTypeNode = (ObjectNode)ObjectUtils.notNull((Object)JsonNodeFactory.instance.objectNode());
            field.getFieldValue().generateJsonSchemaOrDefinitionRef(additionalPropertiesTypeNode, state);
            ObjectNode additionalPropertiesNode = (ObjectNode)ObjectUtils.notNull((Object)JsonNodeFactory.instance.objectNode());
            ArrayNode allOf = additionalPropertiesNode.putArray("allOf");
            allOf.add((JsonNode)additionalPropertiesTypeNode);
            allOf.addObject().put("minProperties", properties.stream().filter(IJsonSchemaPropertyNamed::isRequired).count() + 1L).put("maxProperties", properties.size() + 1);
            node.set("additionalProperties", (JsonNode)additionalPropertiesNode);
        }
    }

    public static void generateAssemblyBody(@NonNull IJsonSchemaDefinitionAssembly assembly, @NonNull ObjectNode node, @NonNull IJsonGenerationState state) {
        node.put("type", "object");
        List<Choice> availableChoices = assembly.getChoices();
        if (availableChoices.size() == 1) {
            JsonSchemaHelper.generateProperties(availableChoices.iterator().next().getCombinations(), node, state);
            node.put("additionalProperties", false);
        } else if (availableChoices.size() > 1) {
            ArrayNode oneOf = node.putArray("anyOf");
            availableChoices.forEach(choice -> {
                ObjectNode schemaNode = (ObjectNode)ObjectUtils.notNull((Object)oneOf.addObject());
                JsonSchemaHelper.generateProperties(choice.getCombinations(), schemaNode, state);
                schemaNode.put("additionalProperties", false);
            });
        }
    }

    @NonNull
    public static Stream<Choice> explodeChoices(@NonNull Choice baseChoice, @NonNull List<? extends IChoiceInstance> choiceInstances, @NonNull IJsonGenerationState state) {
        Stream<Choice> retval = Stream.of(baseChoice);
        for (IChoiceInstance iChoiceInstance : choiceInstances) {
            List<IJsonSchemaPropertyNamed> newChoices = JsonSchemaHelper.buildModelProperties((IContainerModelAbsolute)ObjectUtils.notNull((Object)iChoiceInstance), state);
            retval = retval.flatMap(oldChoice -> oldChoice.explode(newChoices));
        }
        return (Stream)ObjectUtils.notNull(retval);
    }

    private JsonSchemaHelper() {
    }

    private static class FieldValueProperty
    implements IJsonSchemaPropertyNamed {
        private final IJsonSchemaDefinitionField field;

        public FieldValueProperty(IJsonSchemaDefinitionField field) {
            this.field = field;
        }

        @Override
        public String getName() {
            return this.field.getDefinition().getEffectiveJsonValueKeyName();
        }

        @Override
        public Stream<IJsonSchemaDefinable> collectDefinitions(Set<IJsonSchemaDefinitionAssembly> visited, IJsonGenerationState state) {
            return (Stream)ObjectUtils.notNull(Stream.empty());
        }

        @Override
        public void generate(ObjectNode node, IJsonGenerationState state) {
            this.field.getFieldValue().generateJsonSchemaOrDefinitionRef((ObjectNode)ObjectUtils.notNull((Object)node.putObject(this.getName())), state);
        }

        @Override
        public boolean isRequired() {
            return true;
        }
    }

    public static final class Choice {
        @NonNull
        private final List<IJsonSchemaPropertyNamed> combinations;

        public Choice(@NonNull List<IJsonSchemaPropertyNamed> combinations) {
            this.combinations = combinations;
        }

        @NonNull
        public List<IJsonSchemaPropertyNamed> getCombinations() {
            return this.combinations;
        }

        @NonNull
        public Stream<Choice> explode(@NonNull List<IJsonSchemaPropertyNamed> newChoices) {
            return (Stream)ObjectUtils.notNull(newChoices.isEmpty() ? Stream.of(this) : newChoices.stream().map(next -> {
                ArrayList<IJsonSchemaPropertyNamed> retval = new ArrayList<IJsonSchemaPropertyNamed>(this.combinations.size() + 1);
                retval.addAll(this.combinations);
                retval.add((IJsonSchemaPropertyNamed)next);
                return new Choice(CollectionUtil.unmodifiableList(retval));
            }));
        }
    }
}

