/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen.json.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.model.IAssemblyDefinition;
import gov.nist.secauto.metaschema.core.model.IModule;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.schemagen.SchemaGenerationException;
import gov.nist.secauto.metaschema.schemagen.json.impl.IJsonGenerationState;
import gov.nist.secauto.metaschema.schemagen.json.impl.IJsonSchema;
import gov.nist.secauto.metaschema.schemagen.json.impl.IJsonSchemaDefinable;
import gov.nist.secauto.metaschema.schemagen.json.impl.IJsonSchemaDefinitionAssembly;
import gov.nist.secauto.metaschema.schemagen.json.impl.JsonSchemaHelper;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class JsonSchemaModule
implements IJsonSchema {
    private final IModule module;
    private final List<IJsonSchemaDefinitionAssembly> roots;

    public JsonSchemaModule(@NonNull IModule module, @NonNull IJsonGenerationState state) {
        this.module = module;
        this.roots = module.getExportedRootAssemblyDefinitions().stream().map(root -> state.getAssemblyDefinition((IAssemblyDefinition)ObjectUtils.notNull((Object)root), null)).collect(Collectors.toUnmodifiableList());
    }

    @Override
    public boolean isInline(IJsonGenerationState state) {
        return true;
    }

    @NonNull
    public Stream<IJsonSchemaDefinable> collectDefinitions(@NonNull IJsonGenerationState state) {
        return (Stream)ObjectUtils.notNull(this.roots.stream().flatMap(root -> root.collectDefinitions(CollectionUtil.emptySet(), state)));
    }

    @Override
    public void generateInlineJsonSchema(ObjectNode node, IJsonGenerationState state) {
        node.put("$schema", "http://json-schema.org/draft-07/schema#");
        node.put("$id", String.format("%s/%s-%s-schema.json", this.module.getXmlNamespace(), this.module.getShortName(), this.module.getVersion()));
        node.put("$comment", this.module.getName().toMarkdown());
        node.put("type", "object");
        if (this.roots.isEmpty()) {
            throw new SchemaGenerationException("No root definitions found");
        }
        node.set("definitions", (JsonNode)this.generateDefinitions(state));
        if (this.roots.size() == 1) {
            JsonSchemaModule.generateRoot(node, (IJsonSchemaDefinitionAssembly)ObjectUtils.notNull((Object)this.roots.iterator().next()), state);
        } else {
            ArrayNode oneOfNode = node.putArray("oneOf");
            this.roots.forEach(root -> {
                assert (root != null);
                ObjectNode rootNode = (ObjectNode)ObjectUtils.notNull((Object)oneOfNode.addObject());
                assert (rootNode != null);
                JsonSchemaModule.generateRoot(rootNode, root, state);
            });
        }
    }

    private ObjectNode generateDefinitions(@NonNull IJsonGenerationState state) {
        Set usedDefinitions = (Set)ObjectUtils.notNull(this.collectDefinitions(state).collect(Collectors.toUnmodifiableSet()));
        ObjectNode definitionsNode = (ObjectNode)ObjectUtils.notNull((Object)state.getJsonNodeFactory().objectNode());
        usedDefinitions.stream().filter(definition -> !definition.isInline(state)).distinct().sorted(JsonSchemaHelper.DEFINABLE_NAME_COMPARATOR).forEach(definition -> {
            ObjectNode definitionNode = definitionsNode.putObject(definition.getDefinitionName());
            assert (definitionNode != null);
            definition.generateDefinitionJsonSchema(definitionNode, state);
        });
        state.generateDataTypeDefinitions(definitionsNode);
        return definitionsNode;
    }

    private static void generateRoot(@NonNull ObjectNode node, @NonNull IJsonSchemaDefinitionAssembly schema, @NonNull IJsonGenerationState state) {
        ObjectNode propertiesObj = node.putObject("properties");
        propertiesObj.putObject("$schema").put("type", "string").put("format", "uri-reference");
        String name = schema.getDefinition().getRootJsonName();
        schema.generateJsonSchemaOrDefinitionRef((ObjectNode)ObjectUtils.notNull((Object)propertiesObj.putObject(name)), state);
        node.putArray("required").add(name);
        node.put("additionalProperties", false);
    }
}

