/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen.json.impl;

import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.model.IAssemblyInstance;
import gov.nist.secauto.metaschema.core.model.IAssemblyInstanceAbsolute;
import gov.nist.secauto.metaschema.core.model.IFlagInstance;
import gov.nist.secauto.metaschema.core.model.IModelInstanceAbsolute;
import gov.nist.secauto.metaschema.core.model.INamedModelElement;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.schemagen.json.impl.AbstractJsonSchemaPropertyNamed;
import gov.nist.secauto.metaschema.schemagen.json.impl.ICardinalityBehavior;
import gov.nist.secauto.metaschema.schemagen.json.impl.IJsonGenerationState;
import gov.nist.secauto.metaschema.schemagen.json.impl.IJsonSchemaDefinable;
import gov.nist.secauto.metaschema.schemagen.json.impl.IJsonSchemaDefinitionAssembly;
import gov.nist.secauto.metaschema.schemagen.json.impl.IJsonSchemaModelDefinition;
import gov.nist.secauto.metaschema.schemagen.json.impl.JsonSchemaHelper;
import java.util.Set;
import java.util.stream.Stream;
import nl.talsmasoftware.lazy4j.Lazy;

public class JsonSchemaPropertyAssembly
extends AbstractJsonSchemaPropertyNamed<IAssemblyInstanceAbsolute> {
    @NonNull
    private final Lazy<IJsonSchemaModelDefinition> definitionSchema;
    private final IFlagInstance jsonKey;

    public JsonSchemaPropertyAssembly(@NonNull IAssemblyInstanceAbsolute instance, @NonNull IJsonGenerationState state) {
        super(instance, instance.getJsonName());
        this.jsonKey = instance.getJsonKey();
        this.definitionSchema = (Lazy)ObjectUtils.notNull((Object)Lazy.lazy(() -> state.getAssemblyDefinition(instance.getDefinition(), this.jsonKey == null ? null : this.jsonKey.getQName())));
    }

    @Override
    public boolean isRequired() {
        return ((IAssemblyInstanceAbsolute)this.getInstance()).getMinOccurs() > 0;
    }

    @NonNull
    private IJsonSchemaModelDefinition getDefinitionSchema() {
        return (IJsonSchemaModelDefinition)ObjectUtils.notNull((Object)((IJsonSchemaModelDefinition)this.definitionSchema.get()));
    }

    @Override
    protected void generateMetadata(ObjectNode obj, IJsonGenerationState state) {
        IAssemblyInstance instance = (IAssemblyInstance)this.getInstance();
        JsonSchemaHelper.generateTitle((INamedModelElement)instance, obj);
        JsonSchemaHelper.generateDescription(instance, obj);
    }

    @Override
    protected void generateBody(ObjectNode obj, IJsonGenerationState state) {
        ICardinalityBehavior.behaviorFor((IModelInstanceAbsolute)this.getInstance()).generate(obj, (IModelInstanceAbsolute)this.getInstance(), CollectionUtil.singleton((Object)this.getDefinitionSchema()), state);
        assert (!obj.isEmpty());
    }

    @Override
    public Stream<IJsonSchemaDefinable> collectDefinitions(Set<IJsonSchemaDefinitionAssembly> visited, IJsonGenerationState state) {
        return this.getDefinitionSchema().collectDefinitions(visited, state);
    }
}

