/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen.json.impl;

import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.model.IFieldInstance;
import gov.nist.secauto.metaschema.core.model.IFieldInstanceAbsolute;
import gov.nist.secauto.metaschema.core.model.IFlagInstance;
import gov.nist.secauto.metaschema.core.model.IModelInstanceAbsolute;
import gov.nist.secauto.metaschema.core.model.INamedModelElement;
import gov.nist.secauto.metaschema.core.model.IValuedInstance;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import gov.nist.secauto.metaschema.schemagen.json.impl.AbstractJsonSchemaPropertyNamed;
import gov.nist.secauto.metaschema.schemagen.json.impl.ICardinalityBehavior;
import gov.nist.secauto.metaschema.schemagen.json.impl.IJsonGenerationState;
import gov.nist.secauto.metaschema.schemagen.json.impl.IJsonSchemaDefinable;
import gov.nist.secauto.metaschema.schemagen.json.impl.IJsonSchemaDefinitionAssembly;
import gov.nist.secauto.metaschema.schemagen.json.impl.IJsonSchemaModelDefinition;
import gov.nist.secauto.metaschema.schemagen.json.impl.JsonSchemaHelper;
import java.util.Set;
import java.util.stream.Stream;

public class JsonSchemaPropertyField
extends AbstractJsonSchemaPropertyNamed<IFieldInstanceAbsolute> {
    @NonNull
    private final IJsonSchemaModelDefinition definitionSchema;
    private final IFlagInstance jsonKey;

    public JsonSchemaPropertyField(@NonNull IFieldInstanceAbsolute instance, @NonNull IJsonGenerationState state) {
        super(instance, instance.getJsonName());
        this.jsonKey = instance.getJsonKey();
        this.definitionSchema = state.getFieldDefinition(instance.getDefinition(), this.jsonKey == null ? null : this.jsonKey.getQName());
    }

    @Override
    public boolean isRequired() {
        return ((IFieldInstanceAbsolute)this.getInstance()).getMinOccurs() > 0;
    }

    @Override
    public Stream<IJsonSchemaDefinable> collectDefinitions(Set<IJsonSchemaDefinitionAssembly> visited, IJsonGenerationState state) {
        return this.definitionSchema.collectDefinitions(visited, state);
    }

    @Override
    protected void generateMetadata(ObjectNode obj, IJsonGenerationState state) {
        IFieldInstance instance = (IFieldInstance)this.getInstance();
        JsonSchemaHelper.generateTitle((INamedModelElement)instance, obj);
        JsonSchemaHelper.generateDescription(instance, obj);
        JsonSchemaHelper.generateDefault((IValuedInstance)instance, obj);
    }

    @Override
    protected void generateBody(ObjectNode obj, IJsonGenerationState state) {
        ICardinalityBehavior.behaviorFor((IModelInstanceAbsolute)this.getInstance()).generate(obj, (IModelInstanceAbsolute)this.getInstance(), CollectionUtil.singleton((Object)this.definitionSchema), state);
        assert (!obj.isEmpty());
    }
}

