/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen.json.impl;

import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.model.IFlagInstance;
import gov.nist.secauto.metaschema.core.model.INamedModelElement;
import gov.nist.secauto.metaschema.core.model.IValuedInstance;
import gov.nist.secauto.metaschema.schemagen.json.impl.AbstractJsonSchemaPropertyNamed;
import gov.nist.secauto.metaschema.schemagen.json.impl.IJsonGenerationState;
import gov.nist.secauto.metaschema.schemagen.json.impl.IJsonSchemaDefinable;
import gov.nist.secauto.metaschema.schemagen.json.impl.IJsonSchemaDefinition;
import gov.nist.secauto.metaschema.schemagen.json.impl.IJsonSchemaDefinitionAssembly;
import gov.nist.secauto.metaschema.schemagen.json.impl.IJsonSchemaPropertyFlag;
import gov.nist.secauto.metaschema.schemagen.json.impl.JsonSchemaHelper;
import java.util.Set;
import java.util.stream.Stream;

public class JsonSchemaPropertyFlag
extends AbstractJsonSchemaPropertyNamed<IFlagInstance>
implements IJsonSchemaPropertyFlag {
    private final IJsonSchemaDefinition definitionSchema;

    public JsonSchemaPropertyFlag(@NonNull IFlagInstance instance, @NonNull IJsonGenerationState state) {
        super(instance, instance.getJsonName());
        this.definitionSchema = state.getFlagDefinition(instance.getDefinition());
    }

    @Override
    public String getName() {
        return ((IFlagInstance)this.getInstance()).getJsonName();
    }

    @Override
    public boolean isRequired() {
        return ((IFlagInstance)this.getInstance()).isRequired();
    }

    @Override
    public Stream<IJsonSchemaDefinable> collectDefinitions(Set<IJsonSchemaDefinitionAssembly> visited, IJsonGenerationState state) {
        return this.definitionSchema.collectDefinitions(visited, state);
    }

    @Override
    protected void generateMetadata(ObjectNode obj, IJsonGenerationState state) {
        IFlagInstance instance = (IFlagInstance)this.getInstance();
        JsonSchemaHelper.generateTitle((INamedModelElement)instance, obj);
        JsonSchemaHelper.generateDescription(instance, obj);
        JsonSchemaHelper.generateDefault((IValuedInstance)instance, obj);
    }

    @Override
    protected void generateBody(ObjectNode obj, IJsonGenerationState state) {
        this.definitionSchema.generateJsonSchemaOrDefinitionRef(obj, state);
        assert (!obj.isEmpty());
    }
}

