/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen.json.impl;

import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.model.IFieldDefinition;
import gov.nist.secauto.metaschema.core.model.IFieldInstanceGrouped;
import gov.nist.secauto.metaschema.core.model.IValuedDefinition;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.schemagen.json.impl.AbstractJsonSchemaPropertyGrouped;
import gov.nist.secauto.metaschema.schemagen.json.impl.IDataTypeJsonSchema;
import gov.nist.secauto.metaschema.schemagen.json.impl.IJsonGenerationState;
import gov.nist.secauto.metaschema.schemagen.json.impl.IJsonSchemaDefinitionField;
import gov.nist.secauto.metaschema.schemagen.json.impl.IJsonSchemaPropertyNamed;
import gov.nist.secauto.metaschema.schemagen.json.impl.JsonSchemaHelper;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class JsonSchemaPropertyGroupedField
extends AbstractJsonSchemaPropertyGrouped<IFieldInstanceGrouped>
implements IJsonSchemaDefinitionField {
    @NonNull
    private final IDataTypeJsonSchema fieldValueDataType;
    @NonNull
    private final List<? extends IJsonSchemaPropertyNamed> nonValueProperties;

    public JsonSchemaPropertyGroupedField(@NonNull IFieldInstanceGrouped instance, @NonNull IJsonGenerationState state) {
        super(instance, state);
        this.fieldValueDataType = state.getDataTypeSchemaForDefinition((IValuedDefinition)instance.getDefinition());
        this.nonValueProperties = (List)ObjectUtils.notNull(Stream.concat(this.getFlagProperties().stream(), Stream.of(new AbstractJsonSchemaPropertyGrouped.DiscriminatorProperty(this))).collect(Collectors.toUnmodifiableList()));
    }

    @Override
    public IFieldDefinition getDefinition() {
        return ((IFieldInstanceGrouped)this.getInstance()).getDefinition();
    }

    @Override
    public List<? extends IJsonSchemaPropertyNamed> getNonValueProperties() {
        return this.nonValueProperties;
    }

    @Override
    public IDataTypeJsonSchema getFieldValue() {
        return this.fieldValueDataType;
    }

    @Override
    public void generateBody(ObjectNode node, IJsonGenerationState state) {
        JsonSchemaHelper.generateFieldBody(this, node, state);
    }
}

