/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen.xml;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.schemagen.datatype.AbstractDatatypeManager;
import gov.nist.secauto.metaschema.schemagen.xml.impl.IDatatypeProvider;
import gov.nist.secauto.metaschema.schemagen.xml.impl.XmlCoreDatatypeProvider;
import gov.nist.secauto.metaschema.schemagen.xml.impl.XmlMarkupLineDatatypeProvider;
import gov.nist.secauto.metaschema.schemagen.xml.impl.XmlMarkupMultilineDatatypeProvider;
import gov.nist.secauto.metaschema.schemagen.xml.impl.XmlProseCompositDatatypeProvider;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import nl.talsmasoftware.lazy4j.Lazy;
import org.codehaus.stax2.XMLStreamWriter2;

public class XmlDatatypeManager
extends AbstractDatatypeManager {
    public static final String NS_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    @NonNull
    private static final Lazy<List<IDatatypeProvider>> DATATYPE_PROVIDERS = (Lazy)ObjectUtils.notNull((Object)Lazy.lazy(() -> List.of(new XmlCoreDatatypeProvider(), new XmlProseCompositDatatypeProvider((List)ObjectUtils.notNull(List.of(new XmlMarkupMultilineDatatypeProvider(), new XmlMarkupLineDatatypeProvider()))))));

    public void generateDatatypes(@NonNull XMLStreamWriter2 writer) throws XMLStreamException {
        Set<String> used = this.getUsedTypes();
        Set requiredTypes = XmlDatatypeManager.getDatatypeTranslationMap().values().stream().filter(used::contains).collect(Collectors.toCollection(LinkedHashSet::new));
        for (IDatatypeProvider provider : (List)DATATYPE_PROVIDERS.get()) {
            Set<String> providedDatatypes = provider.generateDatatypes(requiredTypes, writer);
            requiredTypes.removeAll(providedDatatypes);
        }
        if (!requiredTypes.isEmpty()) {
            throw new IllegalStateException(String.format("The following datatypes were not provided: %s", requiredTypes.stream().collect(Collectors.joining(","))));
        }
    }
}

