/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen.xml.impl;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import gov.nist.secauto.metaschema.schemagen.xml.impl.IDatatypeContent;
import gov.nist.secauto.metaschema.schemagen.xml.impl.IDatatypeProvider;
import gov.nist.secauto.metaschema.schemagen.xml.impl.JDom2XmlSchemaLoader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.stax2.XMLStreamWriter2;
import org.eclipse.jdt.annotation.Owning;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public abstract class AbstractXmlDatatypeProvider
implements IDatatypeProvider {
    private Map<String, IDatatypeContent> datatypes;

    @Owning
    @NonNull
    protected abstract InputStream getSchemaResource();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSchema() {
        AbstractXmlDatatypeProvider abstractXmlDatatypeProvider = this;
        synchronized (abstractXmlDatatypeProvider) {
            if (this.datatypes == null) {
                try (InputStream is = this.getSchemaResource();){
                    assert (is != null);
                    JDom2XmlSchemaLoader loader = new JDom2XmlSchemaLoader(is);
                    List<Element> elements = this.queryElements(loader);
                    this.datatypes = Collections.unmodifiableMap(this.handleResults(elements));
                }
                catch (IOException | JDOMException ex) {
                    throw new IllegalStateException(ex);
                }
            }
        }
    }

    @NonNull
    protected abstract List<Element> queryElements(JDom2XmlSchemaLoader var1);

    @NonNull
    protected abstract Map<String, IDatatypeContent> handleResults(@NonNull List<Element> var1);

    @Override
    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC", "MT_CORRECTNESS", "EI_EXPOSE_REP"})
    public Map<String, IDatatypeContent> getDatatypes() {
        this.initSchema();
        assert (this.datatypes != null);
        return this.datatypes;
    }

    @Override
    public Set<String> generateDatatypes(Set<String> requiredTypes, @NonNull XMLStreamWriter2 writer) throws XMLStreamException {
        String type;
        Map<String, IDatatypeContent> datatypes = this.getDatatypes();
        LinkedHashSet<String> providedDatatypes = new LinkedHashSet<String>();
        for (IDatatypeContent datatype : datatypes.values()) {
            type = datatype.getTypeName();
            if (!requiredTypes.contains(type)) continue;
            providedDatatypes.add(type);
            providedDatatypes.addAll(datatype.getDependencies());
        }
        for (IDatatypeContent datatype : datatypes.values()) {
            type = datatype.getTypeName();
            if (!providedDatatypes.contains(type)) continue;
            datatype.write((XMLStreamWriter)writer);
        }
        return providedDatatypes;
    }
}

