/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen.xml.impl;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import gov.nist.secauto.metaschema.schemagen.xml.impl.AbstractDatatypeContent;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.StAXStreamOutputter;

public class JDom2DatatypeContent
extends AbstractDatatypeContent {
    @NonNull
    private final List<Element> content;

    public JDom2DatatypeContent(@NonNull String typeName, @NonNull List<Element> content, @NonNull List<String> dependencies) {
        super(typeName, dependencies);
        this.content = CollectionUtil.unmodifiableList(new ArrayList<Element>(content));
    }

    protected List<Element> getContent() {
        return this.content;
    }

    @Override
    public void write(@NonNull XMLStreamWriter writer) throws XMLStreamException {
        Format format = Format.getRawFormat();
        format.setOmitDeclaration(true);
        StAXStreamOutputter out = new StAXStreamOutputter(format);
        for (Element content : this.getContent()) {
            out.output(content, writer);
        }
    }
}

