/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen.xml.impl;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.core.configuration.IConfiguration;
import gov.nist.secauto.metaschema.core.datatype.IDataTypeAdapter;
import gov.nist.secauto.metaschema.core.model.IAssemblyDefinition;
import gov.nist.secauto.metaschema.core.model.IDefinition;
import gov.nist.secauto.metaschema.core.model.IFieldDefinition;
import gov.nist.secauto.metaschema.core.model.IFlagDefinition;
import gov.nist.secauto.metaschema.core.model.IModelElement;
import gov.nist.secauto.metaschema.core.model.IModule;
import gov.nist.secauto.metaschema.core.model.IValuedDefinition;
import gov.nist.secauto.metaschema.core.model.constraint.IAllowedValue;
import gov.nist.secauto.metaschema.core.util.AutoCloser;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.schemagen.AbstractGenerationState;
import gov.nist.secauto.metaschema.schemagen.SchemaGenerationException;
import gov.nist.secauto.metaschema.schemagen.SchemaGenerationFeature;
import gov.nist.secauto.metaschema.schemagen.xml.XmlDatatypeManager;
import gov.nist.secauto.metaschema.schemagen.xml.impl.schematype.IXmlComplexType;
import gov.nist.secauto.metaschema.schemagen.xml.impl.schematype.IXmlSimpleType;
import gov.nist.secauto.metaschema.schemagen.xml.impl.schematype.IXmlType;
import gov.nist.secauto.metaschema.schemagen.xml.impl.schematype.XmlComplexTypeAssemblyDefinition;
import gov.nist.secauto.metaschema.schemagen.xml.impl.schematype.XmlComplexTypeFieldDefinition;
import gov.nist.secauto.metaschema.schemagen.xml.impl.schematype.XmlSimpleTypeDataTypeReference;
import gov.nist.secauto.metaschema.schemagen.xml.impl.schematype.XmlSimpleTypeDataTypeRestriction;
import gov.nist.secauto.metaschema.schemagen.xml.impl.schematype.XmlSimpleTypeUnion;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.XMLStreamWriter2;

public class XmlGenerationState
extends AbstractGenerationState<AutoCloser<XMLStreamWriter2, SchemaGenerationException>, XmlDatatypeManager> {
    @NonNull
    private final String defaultNS;
    @NonNull
    private final Map<String, String> namespaceToPrefixMap = new ConcurrentHashMap<String, String>();
    @NonNull
    private final Map<IDataTypeAdapter<?>, IXmlSimpleType> dataTypeToSimpleTypeMap = new ConcurrentHashMap();
    @NonNull
    private final Map<IValuedDefinition, IXmlSimpleType> definitionToSimpleTypeMap = new ConcurrentHashMap<IValuedDefinition, IXmlSimpleType>();
    @NonNull
    private final Map<IDefinition, IXmlType> definitionToTypeMap = new ConcurrentHashMap<IDefinition, IXmlType>();
    private final AtomicInteger prefixNum = new AtomicInteger();

    public XmlGenerationState(@NonNull IModule module, @NonNull AutoCloser<XMLStreamWriter2, SchemaGenerationException> writer, @NonNull IConfiguration<SchemaGenerationFeature<?>> configuration) {
        super(module, writer, configuration, new XmlDatatypeManager());
        this.defaultNS = (String)ObjectUtils.notNull((Object)module.getXmlNamespace().toASCIIString());
    }

    @NonNull
    public XMLStreamWriter2 getXMLStreamWriter() {
        return (XMLStreamWriter2)((AutoCloser)this.getWriter()).getResource();
    }

    @NonNull
    public String getDefaultNS() {
        return this.defaultNS;
    }

    @NonNull
    public String getDatatypeNS() {
        return this.getDefaultNS();
    }

    @NonNull
    public String getNS(@NonNull IModelElement modelElement) {
        return modelElement.getContainingModule().getXmlNamespace().toASCIIString();
    }

    public String getNSPrefix(String namespace) {
        String retval = null;
        if (!this.getDefaultNS().equals(namespace)) {
            retval = this.namespaceToPrefixMap.computeIfAbsent(namespace, key -> String.format("ns%d", this.prefixNum.incrementAndGet()));
        }
        return retval;
    }

    @NonNull
    protected QName newQName(@NonNull String localName, @NonNull String namespace) {
        String prefix = null;
        if (!this.getDefaultNS().equals(namespace)) {
            prefix = this.getNSPrefix(namespace);
        }
        return (QName)ObjectUtils.notNull((Object)(prefix == null ? new QName(namespace, localName) : new QName(namespace, localName, prefix)));
    }

    @NonNull
    protected QName newQName(@NonNull IDefinition definition, @Nullable String suffix) {
        return this.newQName(this.getTypeNameForDefinition(definition, suffix), this.getNS((IModelElement)definition));
    }

    public IXmlType getXmlForDefinition(@NonNull IDefinition definition) {
        IXmlType retval = this.definitionToTypeMap.get(definition);
        if (retval == null) {
            switch (definition.getModelType()) {
                case FIELD: {
                    IFieldDefinition field = (IFieldDefinition)definition;
                    if (field.getFlagInstances().isEmpty()) {
                        retval = this.getSimpleType((IValuedDefinition)field);
                        break;
                    }
                    retval = this.newComplexType(field);
                    break;
                }
                case ASSEMBLY: {
                    retval = this.newComplexType((IAssemblyDefinition)definition);
                    break;
                }
                case FLAG: {
                    retval = this.getSimpleType((IValuedDefinition)((IFlagDefinition)definition));
                    break;
                }
                case CHOICE_GROUP: 
                case CHOICE: {
                    throw new UnsupportedOperationException(definition.getModelType().toString());
                }
            }
            assert (retval != null) : definition.getModelType();
            this.definitionToTypeMap.put(definition, retval);
        }
        return retval;
    }

    @NonNull
    public IXmlSimpleType getSimpleType(@NonNull IDataTypeAdapter<?> dataType) {
        IXmlSimpleType type = this.dataTypeToSimpleTypeMap.get(dataType);
        if (type == null) {
            QName qname = this.newQName(((XmlDatatypeManager)this.getDatatypeManager()).getTypeNameForDatatype(dataType), this.getDatatypeNS());
            type = new XmlSimpleTypeDataTypeReference(qname, dataType);
            this.dataTypeToSimpleTypeMap.put(dataType, type);
        }
        return type;
    }

    @NonNull
    public IXmlSimpleType getSimpleType(@NonNull IValuedDefinition definition) {
        IXmlSimpleType simpleType = this.definitionToSimpleTypeMap.get(definition);
        if (simpleType == null) {
            AbstractGenerationState.AllowedValueCollection allowedValuesCollection = XmlGenerationState.getContextIndependentEnumeratedValues(definition);
            List<IAllowedValue> allowedValues = allowedValuesCollection.getValues();
            IDataTypeAdapter dataType = definition.getJavaTypeAdapter();
            if (allowedValues.isEmpty()) {
                simpleType = this.getSimpleType(dataType);
            } else {
                simpleType = new XmlSimpleTypeDataTypeRestriction(this.newQName((IDefinition)definition, null), definition, allowedValuesCollection);
                if (!allowedValuesCollection.isClosed()) {
                    simpleType = new XmlSimpleTypeUnion(this.newQName((IDefinition)definition, "Union"), definition, this.getSimpleType(dataType), simpleType);
                }
            }
            this.definitionToSimpleTypeMap.put(definition, simpleType);
        }
        return simpleType;
    }

    @NonNull
    protected IXmlComplexType newComplexType(@NonNull IFieldDefinition definition) {
        QName qname = this.newQName((IDefinition)definition, null);
        return new XmlComplexTypeFieldDefinition(qname, definition);
    }

    @NonNull
    protected IXmlComplexType newComplexType(@NonNull IAssemblyDefinition definition) {
        QName qname = this.newQName((IDefinition)definition, null);
        return new XmlComplexTypeAssemblyDefinition(qname, definition);
    }

    public void generateXmlTypes() throws XMLStreamException {
        for (IXmlType type : this.definitionToTypeMap.values()) {
            if (!type.isInline(this) && type.isGeneratedType(this) && type.isReferenced(this)) {
                type.generate(this);
                continue;
            }
            assert (!type.isGeneratedType(this) || type.isInline(this) || !type.isReferenced(this));
        }
        ((XmlDatatypeManager)this.getDatatypeManager()).generateDatatypes(this.getXMLStreamWriter());
    }

    public void writeAttribute(@NonNull String localName, @NonNull String value) throws XMLStreamException {
        this.getXMLStreamWriter().writeAttribute(localName, value);
    }

    public void writeStartElement(@NonNull String namespaceUri, @NonNull String localName) throws XMLStreamException {
        this.getXMLStreamWriter().writeStartElement(namespaceUri, localName);
    }

    public void writeStartElement(@NonNull String prefix, @NonNull String localName, @NonNull String namespaceUri) throws XMLStreamException {
        this.getXMLStreamWriter().writeStartElement(prefix, localName, namespaceUri);
    }

    public void writeEndElement() throws XMLStreamException {
        this.getXMLStreamWriter().writeEndElement();
    }

    public void writeCharacters(@NonNull String text) throws XMLStreamException {
        this.getXMLStreamWriter().writeCharacters(text);
    }

    public void writeNamespace(String prefix, String namespaceUri) throws XMLStreamException {
        this.getXMLStreamWriter().writeNamespace(prefix, namespaceUri);
    }

    @Override
    public void flushWriter() throws IOException {
        try {
            ((XMLStreamWriter2)((AutoCloser)this.getWriter()).getResource()).flush();
        }
        catch (XMLStreamException ex) {
            throw new IOException(ex);
        }
    }
}

