/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen.xml.impl.schematype;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupDataTypeProvider;
import gov.nist.secauto.metaschema.core.model.IAssemblyDefinition;
import gov.nist.secauto.metaschema.core.model.IChoiceGroupInstance;
import gov.nist.secauto.metaschema.core.model.IChoiceInstance;
import gov.nist.secauto.metaschema.core.model.IDefinition;
import gov.nist.secauto.metaschema.core.model.IFieldInstanceAbsolute;
import gov.nist.secauto.metaschema.core.model.IFlagInstance;
import gov.nist.secauto.metaschema.core.model.IModelInstanceAbsolute;
import gov.nist.secauto.metaschema.core.model.INamedInstance;
import gov.nist.secauto.metaschema.core.model.INamedModelInstanceAbsolute;
import gov.nist.secauto.metaschema.core.model.INamedModelInstanceGrouped;
import gov.nist.secauto.metaschema.core.model.XmlGroupAsBehavior;
import gov.nist.secauto.metaschema.core.qname.IEnhancedQName;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.schemagen.SchemaGenerationException;
import gov.nist.secauto.metaschema.schemagen.xml.impl.DocumentationGenerator;
import gov.nist.secauto.metaschema.schemagen.xml.impl.XmlGenerationState;
import gov.nist.secauto.metaschema.schemagen.xml.impl.schematype.AbstractXmlComplexType;
import gov.nist.secauto.metaschema.schemagen.xml.impl.schematype.IXmlType;
import java.util.Collection;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public class XmlComplexTypeAssemblyDefinition
extends AbstractXmlComplexType<IAssemblyDefinition> {
    public XmlComplexTypeAssemblyDefinition(@NonNull QName qname, @NonNull IAssemblyDefinition definition) {
        super(qname, definition);
    }

    @Override
    protected void generateTypeBody(XmlGenerationState state) throws XMLStreamException {
        Collection flagInstances;
        IAssemblyDefinition definition = (IAssemblyDefinition)this.getDefinition();
        Collection modelInstances = definition.getModelInstances();
        if (!modelInstances.isEmpty()) {
            state.writeStartElement("xs", "sequence", "http://www.w3.org/2001/XMLSchema");
            for (IModelInstanceAbsolute modelInstance : modelInstances) {
                assert (modelInstance != null);
                this.generateModelInstance(modelInstance, state);
            }
            state.writeEndElement();
        }
        if (!(flagInstances = definition.getFlagInstances()).isEmpty()) {
            for (IFlagInstance flagInstance : flagInstances) {
                assert (flagInstance != null);
                XmlComplexTypeAssemblyDefinition.generateFlagInstance(flagInstance, state);
            }
        }
    }

    protected void generateModelInstance(@NonNull IModelInstanceAbsolute modelInstance, @NonNull XmlGenerationState state) throws XMLStreamException {
        boolean grouped = false;
        if (XmlGroupAsBehavior.GROUPED.equals((Object)modelInstance.getXmlGroupAsBehavior())) {
            state.writeStartElement("xs", "element", "http://www.w3.org/2001/XMLSchema");
            IEnhancedQName groupAsQName = (IEnhancedQName)ObjectUtils.requireNonNull((Object)modelInstance.getEffectiveXmlGroupAsQName());
            if (!state.getDefaultNS().equals(groupAsQName.getNamespace())) {
                throw new SchemaGenerationException(String.format("Attempt to create element '%s' on definition '%s' with different namespace", groupAsQName, ((IAssemblyDefinition)this.getDefinition()).toCoordinates()));
            }
            state.writeAttribute("name", (String)ObjectUtils.requireNonNull((Object)groupAsQName.getLocalName()));
            if (modelInstance.getMinOccurs() == 0) {
                state.writeAttribute("minOccurs", "0");
            }
            state.writeStartElement("xs", "complexType", "http://www.w3.org/2001/XMLSchema");
            state.writeStartElement("xs", "sequence", "http://www.w3.org/2001/XMLSchema");
            grouped = true;
        }
        switch (modelInstance.getModelType()) {
            case ASSEMBLY: {
                this.generateNamedModelInstance((INamedModelInstanceAbsolute)modelInstance, grouped, state);
                break;
            }
            case FIELD: {
                IFieldInstanceAbsolute fieldInstance = (IFieldInstanceAbsolute)modelInstance;
                if (fieldInstance.isEffectiveValueWrappedInXml()) {
                    this.generateNamedModelInstance((INamedModelInstanceAbsolute)fieldInstance, grouped, state);
                    break;
                }
                XmlComplexTypeAssemblyDefinition.generateUnwrappedFieldInstance(fieldInstance, grouped, state);
                break;
            }
            case CHOICE: {
                this.generateChoiceModelInstance((IChoiceInstance)modelInstance, state);
                break;
            }
            case CHOICE_GROUP: {
                this.generateChoiceGroupInstance((IChoiceGroupInstance)modelInstance, state);
                break;
            }
            case FLAG: {
                throw new UnsupportedOperationException(modelInstance.getModelType().toString());
            }
        }
        if (grouped) {
            state.writeEndElement();
            state.writeEndElement();
            state.writeEndElement();
        }
    }

    protected void generateNamedModelInstance(@NonNull INamedModelInstanceAbsolute modelInstance, boolean grouped, @NonNull XmlGenerationState state) throws XMLStreamException {
        IXmlType type;
        state.writeStartElement("xs", "element", "http://www.w3.org/2001/XMLSchema");
        state.writeAttribute("name", modelInstance.getEffectiveName());
        if (!grouped && modelInstance.getMinOccurs() != 1) {
            state.writeAttribute("minOccurs", (String)ObjectUtils.notNull((Object)Integer.toString(modelInstance.getMinOccurs())));
        }
        if (modelInstance.getMaxOccurs() != 1) {
            state.writeAttribute("maxOccurs", modelInstance.getMaxOccurs() == -1 ? "unbounded" : (String)ObjectUtils.notNull((Object)Integer.toString(modelInstance.getMaxOccurs())));
        }
        if ((type = state.getXmlForDefinition((IDefinition)modelInstance.getDefinition())).isGeneratedType(state) && type.isInline(state)) {
            DocumentationGenerator.generateDocumentation((INamedInstance)modelInstance, state);
            type.generate(state);
        } else {
            state.writeAttribute("type", type.getTypeReference());
            DocumentationGenerator.generateDocumentation((INamedInstance)modelInstance, state);
        }
        state.writeEndElement();
    }

    protected static void generateUnwrappedFieldInstance(@NonNull IFieldInstanceAbsolute fieldInstance, boolean grouped, @NonNull XmlGenerationState state) throws XMLStreamException {
        if (!MarkupDataTypeProvider.MARKUP_MULTILINE.equals(fieldInstance.getDefinition().getJavaTypeAdapter())) {
            throw new IllegalStateException();
        }
        state.writeStartElement("xs", "group", "http://www.w3.org/2001/XMLSchema");
        state.writeAttribute("ref", "blockElementGroup");
        if (!grouped && fieldInstance.getMinOccurs() != 1) {
            state.writeAttribute("minOccurs", (String)ObjectUtils.notNull((Object)Integer.toString(fieldInstance.getMinOccurs())));
        }
        state.writeAttribute("maxOccurs", "unbounded");
        DocumentationGenerator.generateDocumentation((INamedInstance)fieldInstance, state);
        state.writeEndElement();
    }

    protected void generateChoiceModelInstance(@NonNull IChoiceInstance choice, @NonNull XmlGenerationState state) throws XMLStreamException {
        state.writeStartElement("xs", "choice", "http://www.w3.org/2001/XMLSchema");
        for (IModelInstanceAbsolute instance : choice.getModelInstances()) {
            assert (instance != null);
            if (instance instanceof IChoiceInstance) {
                this.generateChoiceModelInstance((IChoiceInstance)instance, state);
                continue;
            }
            this.generateModelInstance(instance, state);
        }
        state.writeEndElement();
    }

    private void generateChoiceGroupInstance(IChoiceGroupInstance choiceGroup, XmlGenerationState state) throws XMLStreamException {
        int max;
        state.writeStartElement("xs", "choice", "http://www.w3.org/2001/XMLSchema");
        int min = choiceGroup.getMinOccurs();
        if (min != 1) {
            state.writeAttribute("minOccurs", (String)ObjectUtils.notNull((Object)Integer.toString(min)));
        }
        if ((max = choiceGroup.getMaxOccurs()) < 0) {
            state.writeAttribute("maxOccurs", "unbounded");
        } else if (max > 1) {
            state.writeAttribute("maxOccurs", (String)ObjectUtils.notNull((Object)Integer.toString(max)));
        }
        for (INamedModelInstanceGrouped instance : choiceGroup.getNamedModelInstances()) {
            assert (instance != null);
            this.generateGroupedNamedModelInstance(instance, state);
        }
        state.writeEndElement();
    }

    protected void generateGroupedNamedModelInstance(@NonNull INamedModelInstanceGrouped instance, @NonNull XmlGenerationState state) throws XMLStreamException {
        state.writeStartElement("xs", "element", "http://www.w3.org/2001/XMLSchema");
        state.writeAttribute("name", instance.getEffectiveName());
        IXmlType type = state.getXmlForDefinition((IDefinition)instance.getDefinition());
        if (type.isGeneratedType(state) && type.isInline(state)) {
            DocumentationGenerator.generateDocumentation((INamedInstance)instance, state);
            type.generate(state);
        } else {
            state.writeAttribute("type", type.getTypeReference());
            DocumentationGenerator.generateDocumentation((INamedInstance)instance, state);
        }
        state.writeEndElement();
    }
}

