/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.model.testing;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IModule;
import gov.nist.secauto.metaschema.core.model.MetaschemaException;
import gov.nist.secauto.metaschema.core.model.validation.IContentValidator;
import gov.nist.secauto.metaschema.core.model.validation.IValidationFinding;
import gov.nist.secauto.metaschema.core.model.validation.IValidationResult;
import gov.nist.secauto.metaschema.core.model.validation.JsonSchemaContentValidator;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.IBindingContext;
import gov.nist.secauto.metaschema.databind.io.Format;
import gov.nist.secauto.metaschema.databind.io.ISerializer;
import gov.nist.secauto.metaschema.databind.model.metaschema.IBindingModuleLoader;
import gov.nist.secauto.metaschema.model.testing.xml.xmlbeans.ContentCaseType;
import gov.nist.secauto.metaschema.model.testing.xml.xmlbeans.GenerateSchemaDocument;
import gov.nist.secauto.metaschema.model.testing.xml.xmlbeans.MetaschemaDocument;
import gov.nist.secauto.metaschema.model.testing.xml.xmlbeans.TestCollectionDocument;
import gov.nist.secauto.metaschema.model.testing.xml.xmlbeans.TestScenarioDocument;
import gov.nist.secauto.metaschema.model.testing.xml.xmlbeans.TestSuiteDocument;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import nl.talsmasoftware.lazy4j.Lazy;
import org.apache.logging.log4j.LogBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DynamicContainer;
import org.junit.jupiter.api.DynamicNode;
import org.junit.jupiter.api.DynamicTest;
import org.junit.platform.commons.JUnitException;

public abstract class AbstractTestSuite {
    private static final Logger LOGGER = LogManager.getLogger(AbstractTestSuite.class);
    private static final boolean DELETE_RESULTS_ON_EXIT = false;
    private static final OpenOption[] OPEN_OPTIONS_TRUNCATE = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING};

    @NonNull
    protected abstract Format getRequiredContentFormat();

    @NonNull
    protected abstract URI getTestSuiteURI();

    @NonNull
    protected abstract Path getGenerationPath();

    @NonNull
    protected abstract BiFunction<IModule, Writer, Void> getSchemaGeneratorSupplier();

    @Nullable
    protected abstract Supplier<? extends IContentValidator> getSchemaValidatorSupplier();

    @NonNull
    protected abstract Function<Path, ? extends IContentValidator> getContentValidatorSupplier();

    @NonNull
    protected Stream<DynamicNode> testFactory(@NonNull IBindingContext bindingContext) {
        try {
            XmlOptions options = new XmlOptions();
            options.setBaseURI(null);
            options.setLoadLineNumbers();
            Path generationPath = this.getGenerationPath();
            if (Files.exists(generationPath, new LinkOption[0])) {
                if (!Files.isDirectory(generationPath, new LinkOption[0])) {
                    throw new JUnitException(String.format("Generation path '%s' exists and is not a directory", generationPath));
                }
            } else {
                Files.createDirectories(generationPath, new FileAttribute[0]);
            }
            URI testSuiteUri = this.getTestSuiteURI();
            URL testSuiteUrl = testSuiteUri.toURL();
            TestSuiteDocument directive = (TestSuiteDocument)TestSuiteDocument.Factory.parse(testSuiteUrl, options);
            return (Stream)ObjectUtils.notNull(directive.getTestSuite().getTestCollectionList().stream().flatMap(collection -> Stream.of(this.generateCollection((TestCollectionDocument.TestCollection)ObjectUtils.notNull((Object)collection), testSuiteUri, generationPath, bindingContext))));
        }
        catch (IOException | XmlException ex) {
            throw new JUnitException("Unable to generate tests", ex);
        }
    }

    protected void deleteCollectionOnExit(@NonNull Path path) {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Files.delete(file);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException ex) throws IOException {
                        if (ex == null) {
                            Files.delete(dir);
                            return FileVisitResult.CONTINUE;
                        }
                        throw ex;
                    }
                });
            }
            catch (IOException ex) {
                throw new JUnitException("Failed to delete collection: " + path, (Throwable)ex);
            }
        }));
    }

    private DynamicContainer generateCollection(@NonNull TestCollectionDocument.TestCollection collection, @NonNull URI testSuiteUri, @NonNull Path generationPath, @NonNull IBindingContext bindingContext) {
        URI collectionUri = testSuiteUri.resolve(collection.getLocation());
        assert (collectionUri != null);
        LOGGER.atInfo().log("Collection: " + collectionUri);
        Lazy collectionGenerationPath = (Lazy)ObjectUtils.notNull((Object)Lazy.lazy(() -> {
            Path retval;
            try {
                retval = (Path)ObjectUtils.requireNonNull((Object)Files.createTempDirectory(generationPath, "collection-", new FileAttribute[0]));
            }
            catch (IOException ex) {
                throw new JUnitException("Unable to create collection temp directory", (Throwable)ex);
            }
            return retval;
        }));
        return DynamicContainer.dynamicContainer((String)collection.getName(), (URI)testSuiteUri, (Stream)((Stream)collection.getTestScenarioList().stream().flatMap(scenario -> {
            assert (scenario != null);
            return Stream.of(this.generateScenario((TestScenarioDocument.TestScenario)scenario, collectionUri, (Lazy<Path>)collectionGenerationPath, bindingContext));
        }).sequential()));
    }

    protected void generateSchema(@NonNull IModule module, @NonNull Path schemaPath, @NonNull BiFunction<IModule, Writer, Void> schemaProducer) throws IOException {
        Path parentDir = schemaPath.getParent();
        if (parentDir != null && !Files.exists(parentDir, new LinkOption[0])) {
            Files.createDirectories(parentDir, new FileAttribute[0]);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(schemaPath, StandardCharsets.UTF_8, this.getWriteOpenOptions());){
            schemaProducer.apply(module, writer);
        }
        LOGGER.atInfo().log("Produced schema '{}' for module '{}'", (Object)schemaPath, (Object)module.getLocation());
    }

    protected OpenOption[] getWriteOpenOptions() {
        return OPEN_OPTIONS_TRUNCATE;
    }

    private DynamicContainer generateScenario(@NonNull TestScenarioDocument.TestScenario scenario, @NonNull URI collectionUri, @NonNull Lazy<Path> collectionGenerationPath, @NonNull IBindingContext bindingContext) {
        IModule module;
        Lazy scenarioGenerationPath = Lazy.lazy(() -> {
            Path retval;
            try {
                retval = Files.createTempDirectory((Path)collectionGenerationPath.get(), "scenario-", new FileAttribute[0]);
            }
            catch (IOException ex) {
                throw new JUnitException("Unable to create scenario temp directory", (Throwable)ex);
            }
            return retval;
        });
        GenerateSchemaDocument.GenerateSchema generateSchema = scenario.getGenerateSchema();
        MetaschemaDocument.Metaschema metaschemaDirective = generateSchema.getMetaschema();
        URI metaschemaUri = collectionUri.resolve(metaschemaDirective.getLocation());
        try {
            IBindingModuleLoader loader = bindingContext.newModuleLoader();
            module = (IModule)loader.load((URL)ObjectUtils.notNull((Object)metaschemaUri.toURL()));
        }
        catch (MetaschemaException | IOException ex) {
            throw new JUnitException("Unable to generate classes for metaschema: " + metaschemaUri, ex);
        }
        Lazy lazySchema = Lazy.lazy(() -> {
            Path schemaPath;
            String schemaExtension;
            Format requiredContentFormat = this.getRequiredContentFormat();
            switch (requiredContentFormat) {
                case JSON: 
                case YAML: {
                    schemaExtension = ".json";
                    break;
                }
                case XML: {
                    schemaExtension = ".xsd";
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            try {
                schemaPath = Files.createTempFile((Path)scenarioGenerationPath.get(), "", "-schema" + schemaExtension, new FileAttribute[0]);
            }
            catch (IOException ex) {
                throw new JUnitException("Unable to create schema temp file", (Throwable)ex);
            }
            try {
                this.generateSchema((IModule)ObjectUtils.notNull((Object)module), (Path)ObjectUtils.notNull((Object)schemaPath), this.getSchemaGeneratorSupplier());
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
            return schemaPath;
        });
        Lazy lazyContentValidator = Lazy.lazy(() -> {
            Path schemaPath = (Path)lazySchema.get();
            return this.getContentValidatorSupplier().apply(schemaPath);
        });
        assert (lazyContentValidator != null);
        DynamicTest validateSchema = DynamicTest.dynamicTest((String)"Validate Schema", () -> {
            Supplier<? extends IContentValidator> supplier = this.getSchemaValidatorSupplier();
            if (supplier != null) {
                Path schemaPath;
                try {
                    schemaPath = (Path)ObjectUtils.requireNonNull((Object)((Path)lazySchema.get()));
                }
                catch (Exception ex) {
                    throw new JUnitException("failed to generate schema", (Throwable)ex);
                }
                AbstractTestSuite.validateWithSchema((IContentValidator)ObjectUtils.requireNonNull((Object)supplier.get()), schemaPath);
            }
        });
        Stream contentTests = (Stream)scenario.getValidationCaseList().stream().flatMap(contentCase -> {
            assert (contentCase != null);
            DynamicTest test = this.generateValidationCase((ContentCaseType)contentCase, bindingContext, (Lazy<IContentValidator>)lazyContentValidator, collectionUri, (Lazy<Path>)((Lazy)ObjectUtils.notNull((Object)scenarioGenerationPath)));
            return test == null ? Stream.empty() : Stream.of(test);
        }).sequential();
        return DynamicContainer.dynamicContainer((String)scenario.getName(), (URI)metaschemaUri, (Stream)((Stream)Stream.concat(Stream.of(validateSchema), contentTests).sequential()));
    }

    protected Path convertContent(@NonNull URI resource, @NonNull Path generationPath, @NonNull IBindingContext context) throws IOException {
        Path convertedContetPath;
        IBoundObject object;
        try {
            object = context.newBoundLoader().load((URL)ObjectUtils.notNull((Object)resource.toURL()));
        }
        catch (URISyntaxException ex) {
            throw new IOException(ex);
        }
        if (!Files.exists(generationPath, new LinkOption[0])) {
            Files.createDirectories(generationPath, new FileAttribute[0]);
        }
        try {
            convertedContetPath = (Path)ObjectUtils.notNull((Object)Files.createTempFile(generationPath, "", "-content", new FileAttribute[0]));
        }
        catch (IOException ex) {
            throw new JUnitException(String.format("Unable to create converted content path in location '%s'", generationPath), (Throwable)ex);
        }
        Format toFormat = this.getRequiredContentFormat();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.atInfo().log("Converting content '{}' to {} as '{}'", (Object)resource, (Object)toFormat, (Object)convertedContetPath);
        }
        ISerializer serializer = context.newSerializer(toFormat, (Class)ObjectUtils.asType(object.getClass()));
        serializer.serialize((IBoundObject)ObjectUtils.asType((Object)object), convertedContetPath, this.getWriteOpenOptions());
        return convertedContetPath;
    }

    private DynamicTest generateValidationCase(@NonNull ContentCaseType contentCase, @NonNull IBindingContext bindingContext, @NonNull Lazy<IContentValidator> lazyContentValidator, @NonNull URI collectionUri, @NonNull Lazy<Path> resourceGenerationPath) {
        URI contentUri = (URI)ObjectUtils.notNull((Object)collectionUri.resolve(contentCase.getLocation()));
        Format format = contentCase.getSourceFormat();
        DynamicTest retval = null;
        if (this.getRequiredContentFormat().equals((Object)format)) {
            retval = DynamicTest.dynamicTest((String)String.format("Validate %s=%s: %s", format, contentCase.getValidationResult(), contentCase.getLocation()), (URI)contentUri, () -> {
                IContentValidator contentValidator;
                try {
                    contentValidator = (IContentValidator)lazyContentValidator.get();
                }
                catch (Exception ex) {
                    throw new JUnitException("failed to produce the content validator", ex.getCause());
                }
                Assertions.assertEquals((Object)contentCase.getValidationResult(), (Object)AbstractTestSuite.validateWithSchema((IContentValidator)ObjectUtils.notNull((Object)contentValidator), (URL)ObjectUtils.notNull((Object)contentUri.toURL())), (String)("validation did not match expectation for: " + contentUri.toASCIIString()));
            });
        } else if (contentCase.getValidationResult().booleanValue()) {
            retval = DynamicTest.dynamicTest((String)String.format("Convert and Validate %s=%s: %s", format, contentCase.getValidationResult(), contentCase.getLocation()), (URI)contentUri, () -> {
                IContentValidator contentValidator;
                Path convertedContetPath;
                try {
                    convertedContetPath = this.convertContent(contentUri, (Path)ObjectUtils.notNull((Object)((Path)resourceGenerationPath.get())), bindingContext);
                }
                catch (Exception ex) {
                    throw new JUnitException("failed to convert content: " + contentUri, (Throwable)ex);
                }
                try {
                    contentValidator = (IContentValidator)lazyContentValidator.get();
                }
                catch (Exception ex) {
                    throw new JUnitException("failed to produce the content validator", ex.getCause());
                }
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.atInfo().log("Validating content '{}'", (Object)convertedContetPath);
                }
                Assertions.assertEquals((Object)contentCase.getValidationResult(), (Object)AbstractTestSuite.validateWithSchema((IContentValidator)ObjectUtils.notNull((Object)contentValidator), (URL)ObjectUtils.notNull((Object)convertedContetPath.toUri().toURL())), (String)String.format("validation of '%s' did not match expectation", convertedContetPath));
            });
        }
        return retval;
    }

    private static boolean validateWithSchema(@NonNull IContentValidator validator, @NonNull URL target) throws IOException {
        IValidationResult schemaValidationResult;
        try {
            schemaValidationResult = validator.validate(target);
        }
        catch (URISyntaxException ex) {
            throw new IOException(ex);
        }
        return AbstractTestSuite.processValidationResult(schemaValidationResult);
    }

    protected static boolean validateWithSchema(@NonNull IContentValidator validator, @NonNull Path target) throws IOException {
        IValidationResult schemaValidationResult = validator.validate(target);
        if (!schemaValidationResult.isPassing()) {
            LOGGER.atError().log("Schema validation failed for: {}", (Object)target);
        }
        return AbstractTestSuite.processValidationResult(schemaValidationResult);
    }

    private static boolean processValidationResult(IValidationResult schemaValidationResult) {
        for (IValidationFinding finding : schemaValidationResult.getFindings()) {
            AbstractTestSuite.logFinding((IValidationFinding)ObjectUtils.notNull((Object)finding));
        }
        return schemaValidationResult.isPassing();
    }

    private static void logFinding(@NonNull IValidationFinding finding) {
        LogBuilder logBuilder;
        switch (finding.getSeverity()) {
            case CRITICAL: {
                logBuilder = LOGGER.atFatal();
                break;
            }
            case ERROR: {
                logBuilder = LOGGER.atError();
                break;
            }
            case WARNING: {
                logBuilder = LOGGER.atWarn();
                break;
            }
            case INFORMATIONAL: {
                logBuilder = LOGGER.atInfo();
                break;
            }
            case DEBUG: {
                logBuilder = LOGGER.atDebug();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown level: " + finding.getSeverity().name());
            }
        }
        if (finding instanceof JsonSchemaContentValidator.JsonValidationFinding) {
            JsonSchemaContentValidator.JsonValidationFinding jsonFinding = (JsonSchemaContentValidator.JsonValidationFinding)finding;
            logBuilder.log("[{}] {}", (Object)jsonFinding.getCause().getPointerToViolation(), (Object)finding.getMessage());
        } else {
            logBuilder.log("{}", (Object)finding.getMessage());
        }
    }
}

