/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.oscal.lib.model.BackMatter;
import java.net.URI;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class OscalUtils {
    private static final Pattern INTERNAL_REFERENCE_FRAGMENT_PATTERN = Pattern.compile("^#(.+)$");

    private OscalUtils() {
    }

    public static boolean isInternalReference(@NonNull URI uri) {
        if (uri.isAbsolute()) {
            return false;
        }
        String schemeSpecificPart = uri.getSchemeSpecificPart();
        return uri.getScheme() == null && (schemeSpecificPart == null || schemeSpecificPart.isEmpty()) && uri.getFragment() != null;
    }

    @NonNull
    public static String internalReferenceFragmentToId(@NonNull URI fragment) {
        return OscalUtils.internalReferenceFragmentToId((String)ObjectUtils.notNull((Object)fragment.toString()));
    }

    @NonNull
    public static String internalReferenceFragmentToId(@NonNull String fragment) {
        Matcher matcher = INTERNAL_REFERENCE_FRAGMENT_PATTERN.matcher(fragment);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.format("The fragment '%s' does not match the pattern '%s'", fragment, INTERNAL_REFERENCE_FRAGMENT_PATTERN.pattern()));
        }
        String retval = (String)ObjectUtils.notNull((Object)matcher.group(1));
        return retval;
    }

    @Nullable
    public static BackMatter.Resource.Rlink findMatchingRLink(@NonNull BackMatter.Resource resource, @Nullable String preferredMediaType) {
        List<BackMatter.Resource.Rlink> rlinks = resource.getRlinks();
        BackMatter.Resource.Rlink retval = null;
        if (rlinks != null) {
            retval = preferredMediaType != null ? (BackMatter.Resource.Rlink)rlinks.stream().filter(rlink -> preferredMediaType.equals(rlink.getMediaType())).findFirst().orElse(null) : (BackMatter.Resource.Rlink)rlinks.stream().findFirst().orElse(null);
        }
        return retval;
    }
}

