/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.metapath.function.library;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.metapath.DynamicContext;
import gov.nist.secauto.metaschema.core.metapath.ISequence;
import gov.nist.secauto.metaschema.core.metapath.MetapathConstants;
import gov.nist.secauto.metaschema.core.metapath.MetapathException;
import gov.nist.secauto.metaschema.core.metapath.function.FunctionUtils;
import gov.nist.secauto.metaschema.core.metapath.function.IArgument;
import gov.nist.secauto.metaschema.core.metapath.function.IFunction;
import gov.nist.secauto.metaschema.core.metapath.function.InvalidTypeFunctionException;
import gov.nist.secauto.metaschema.core.metapath.function.library.FnData;
import gov.nist.secauto.metaschema.core.metapath.item.IItem;
import gov.nist.secauto.metaschema.core.metapath.item.atomic.IAnyAtomicItem;
import gov.nist.secauto.metaschema.core.metapath.item.atomic.IAnyUriItem;
import gov.nist.secauto.metaschema.core.metapath.item.atomic.IBooleanItem;
import gov.nist.secauto.metaschema.core.metapath.item.atomic.IStringItem;
import gov.nist.secauto.metaschema.core.metapath.item.node.IAssemblyNodeItem;
import gov.nist.secauto.metaschema.core.metapath.item.node.IFlagNodeItem;
import gov.nist.secauto.metaschema.core.model.IAssemblyDefinition;
import gov.nist.secauto.metaschema.core.model.IFlagInstance;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.oscal.lib.model.metadata.AbstractProperty;
import java.net.URI;
import java.util.List;
import javax.xml.namespace.QName;

public final class HasOscalNamespace {
    @NonNull
    private static final QName NS_FLAG_QNAME = new QName("ns");
    @NonNull
    static final IFunction SIGNATURE_ONE_ARG = IFunction.builder().name("has-oscal-namespace").namespace("http://csrc.nist.gov/ns/oscal/1.0").argument(IArgument.builder().name("namespace").type(IStringItem.class).oneOrMore().build()).allowUnboundedArity(true).returnType(IBooleanItem.class).focusDependent().contextIndependent().deterministic().returnOne().functionHandler(HasOscalNamespace::executeOneArg).build();
    @NonNull
    static final IFunction SIGNATURE_TWO_ARGS = IFunction.builder().name("has-oscal-namespace").namespace("http://csrc.nist.gov/ns/oscal/1.0").argument(IArgument.builder().name("propOrPart").type(IAssemblyNodeItem.class).one().build()).argument(IArgument.builder().name("namespace").type(IStringItem.class).oneOrMore().build()).allowUnboundedArity(true).focusIndependent().contextIndependent().deterministic().returnType(IBooleanItem.class).returnOne().functionHandler(HasOscalNamespace::executeTwoArg).build();
    @NonNull
    static final IFunction SIGNATURE_ONE_ARG_METAPATH = IFunction.builder().name("has-oscal-namespace").namespace(MetapathConstants.NS_METAPATH_FUNCTIONS).argument(IArgument.builder().name("namespace").type(IStringItem.class).oneOrMore().build()).allowUnboundedArity(true).returnType(IBooleanItem.class).focusDependent().contextIndependent().deterministic().returnOne().functionHandler(HasOscalNamespace::executeOneArg).build();
    @NonNull
    static final IFunction SIGNATURE_TWO_ARGS_METAPATH = IFunction.builder().name("has-oscal-namespace").namespace(MetapathConstants.NS_METAPATH_FUNCTIONS).argument(IArgument.builder().name("propOrPart").type(IAssemblyNodeItem.class).one().build()).argument(IArgument.builder().name("namespace").type(IStringItem.class).oneOrMore().build()).allowUnboundedArity(true).focusIndependent().contextIndependent().deterministic().returnType(IBooleanItem.class).returnOne().functionHandler(HasOscalNamespace::executeTwoArg).build();

    private HasOscalNamespace() {
    }

    @NonNull
    public static ISequence<?> executeOneArg(@NonNull IFunction function, @NonNull List<ISequence<?>> arguments, @NonNull DynamicContext dynamicContext, IItem focus) {
        assert (arguments.size() == 1);
        ISequence namespaceArgs = FunctionUtils.asType((ISequence)((ISequence)ObjectUtils.notNull(arguments.get(0))));
        if (namespaceArgs.isEmpty()) {
            return ISequence.empty();
        }
        IAssemblyNodeItem node = (IAssemblyNodeItem)FunctionUtils.requireType(IAssemblyNodeItem.class, (IItem)focus);
        return ISequence.of((IItem)HasOscalNamespace.hasNamespace((IAssemblyNodeItem)FunctionUtils.asType((IItem)node), (ISequence<? extends IStringItem>)namespaceArgs));
    }

    @NonNull
    public static ISequence<?> executeTwoArg(@NonNull IFunction function, @NonNull List<ISequence<?>> arguments, @NonNull DynamicContext dynamicContext, IItem focus) {
        assert (arguments.size() == 2);
        ISequence namespaceArgs = FunctionUtils.asType((ISequence)((ISequence)ObjectUtils.notNull(arguments.get(1))));
        if (namespaceArgs.isEmpty()) {
            return ISequence.empty();
        }
        ISequence nodeSequence = FunctionUtils.asType((ISequence)((ISequence)ObjectUtils.notNull(arguments.get(0))));
        IAssemblyNodeItem node = (IAssemblyNodeItem)FunctionUtils.asType((IItem)((IItem)ObjectUtils.requireNonNull((Object)((IAssemblyNodeItem)nodeSequence.getFirstItem(true)))));
        return ISequence.of((IItem)HasOscalNamespace.hasNamespace(node, (ISequence<? extends IStringItem>)namespaceArgs));
    }

    @NonNull
    public static IBooleanItem hasNamespace(@NonNull IAssemblyNodeItem propOrPart, @NonNull ISequence<? extends IStringItem> namespaces) {
        Object propOrPartObject = propOrPart.getValue();
        if (propOrPartObject == null) {
            throw new InvalidTypeFunctionException(12, (IItem)propOrPart);
        }
        URI nodeNamespace = null;
        IFlagNodeItem ns = propOrPart.getFlagByName(NS_FLAG_QNAME);
        if (ns == null) {
            IAssemblyDefinition definition = (IAssemblyDefinition)propOrPart.getDefinition();
            IFlagInstance flag = definition.getFlagInstanceByName(NS_FLAG_QNAME);
            if (flag == null) {
                throw new MetapathException(String.format("Node at path '%s' bound to '%s' based on the assembly definition '%s' has no OSCAL namespace", propOrPart.getMetapath(), propOrPart.getClass().getName(), ((IAssemblyDefinition)propOrPart.getDefinition()).getName()));
            }
            Object defaultValue = flag.getDefinition().getDefaultValue();
            if (defaultValue != null) {
                nodeNamespace = IAnyUriItem.valueOf((String)((String)ObjectUtils.notNull((Object)defaultValue.toString()))).asUri();
            }
        } else {
            nodeNamespace = IAnyUriItem.cast((IAnyAtomicItem)FnData.fnDataItem((IItem)ns)).asUri();
        }
        String nodeNamespaceString = AbstractProperty.normalizeNamespace(nodeNamespace).toString();
        return IBooleanItem.valueOf((boolean)namespaces.stream().map(node -> nodeNamespaceString.equals(node.asString())).anyMatch(bool -> bool));
    }
}

