/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model;

import gov.nist.secauto.metaschema.core.datatype.adapter.DateTimeWithTZAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.TokenAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.UriAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.UuidAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultilineAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValue;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValues;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.IndexHasKey;
import gov.nist.secauto.metaschema.databind.model.annotations.KeyField;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.ValueConstraints;
import gov.nist.secauto.oscal.lib.model.Link;
import gov.nist.secauto.oscal.lib.model.OscalMetadataModule;
import gov.nist.secauto.oscal.lib.model.Property;
import gov.nist.secauto.oscal.lib.model.ResponsibleParty;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(formalName="Action", description="An action applied by a role within a given party to the content.", name="action", moduleClass=OscalMetadataModule.class, valueConstraints=@ValueConstraints(allowedValues={@AllowedValues(level=IConstraint.Level.ERROR, target="./system/@value", allowOthers=true, values={@AllowedValue(value="http://csrc.nist.gov/ns/oscal", description="This value identifies action types defined in the NIST OSCAL namespace.")}), @AllowedValues(level=IConstraint.Level.ERROR, target="./type[has-oscal-namespace('http://csrc.nist.gov/ns/oscal')]/@value", values={@AllowedValue(value="approval", description="An approval of a document instance's content."), @AllowedValue(value="request-changes", description="A request from the responisble party or parties to change the content.")})}, indexHasKey={@IndexHasKey(level=IConstraint.Level.ERROR, target="responsible-party", indexName="index-metadata-role-id", keyFields={@KeyField(target="@role-id")}), @IndexHasKey(level=IConstraint.Level.ERROR, target="responsible-party", indexName="index-metadata-party-uuid", keyFields={@KeyField(target="party-uuid")})}))
public class Action
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundFlag(formalName="Action Universally Unique Identifier", description="A unique identifier that can be used to reference this defined action elsewhere in an OSCAL document. A UUID should be consistently used for a given location across revisions of the document.", name="uuid", required=true, typeAdapter=UuidAdapter.class)
    private UUID _uuid;
    @BoundFlag(formalName="Action Occurrence Date", description="The date and time when the action occurred.", name="date", typeAdapter=DateTimeWithTZAdapter.class)
    private ZonedDateTime _date;
    @BoundFlag(formalName="Action Type", description="The type of action documented by the assembly, such as an approval.", name="type", required=true, typeAdapter=TokenAdapter.class)
    private String _type;
    @BoundFlag(formalName="Action Type System", description="Specifies the action type system used.", name="system", required=true, typeAdapter=UriAdapter.class, remarks="Provides a means to segment the value space for the `type`, so that different organizations and individuals can assert control over the allowed `action`'s `type`. This allows the semantics associated with a given `type` to be defined on an organization-by-organization basis.\n\nAn organization MUST use a URI that they have control over. e.g., a domain registered to the organization in a URI, a registered uniform resource names (URN) namespace.")
    private URI _system;
    @BoundAssembly(formalName="Property", description="An attribute, characteristic, or quality of the containing object expressed as a namespace qualified name/value pair.", useName="prop", maxOccurs=-1, groupAs=@GroupAs(name="props", inJson=JsonGroupAsBehavior.LIST))
    private List<Property> _props;
    @BoundAssembly(formalName="Link", description="A reference to a local or remote resource, that has a specific relation to the containing object.", useName="link", maxOccurs=-1, groupAs=@GroupAs(name="links", inJson=JsonGroupAsBehavior.LIST))
    private List<Link> _links;
    @BoundAssembly(formalName="Responsible Party", description="A reference to a set of persons and/or organizations that have responsibility for performing the referenced role in the context of the containing object.", useName="responsible-party", maxOccurs=-1, groupAs=@GroupAs(name="responsible-parties", inJson=JsonGroupAsBehavior.LIST))
    private List<ResponsibleParty> _responsibleParties;
    @BoundField(formalName="Remarks", description="Additional commentary about the containing object.", useName="remarks", typeAdapter=MarkupMultilineAdapter.class)
    private MarkupMultiline _remarks;

    public Action() {
        this(null);
    }

    public Action(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public UUID getUuid() {
        return this._uuid;
    }

    public void setUuid(UUID value) {
        this._uuid = value;
    }

    public ZonedDateTime getDate() {
        return this._date;
    }

    public void setDate(ZonedDateTime value) {
        this._date = value;
    }

    public String getType() {
        return this._type;
    }

    public void setType(String value) {
        this._type = value;
    }

    public URI getSystem() {
        return this._system;
    }

    public void setSystem(URI value) {
        this._system = value;
    }

    public List<Property> getProps() {
        return this._props;
    }

    public void setProps(List<Property> value) {
        this._props = value;
    }

    public boolean addProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._props == null) {
            this._props = new LinkedList<Property>();
        }
        return this._props.add(value);
    }

    public boolean removeProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._props != null && this._props.remove(value);
    }

    public List<Link> getLinks() {
        return this._links;
    }

    public void setLinks(List<Link> value) {
        this._links = value;
    }

    public boolean addLink(Link item) {
        Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._links == null) {
            this._links = new LinkedList<Link>();
        }
        return this._links.add(value);
    }

    public boolean removeLink(Link item) {
        Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._links != null && this._links.remove(value);
    }

    public List<ResponsibleParty> getResponsibleParties() {
        return this._responsibleParties;
    }

    public void setResponsibleParties(List<ResponsibleParty> value) {
        this._responsibleParties = value;
    }

    public boolean addResponsibleParty(ResponsibleParty item) {
        ResponsibleParty value = (ResponsibleParty)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._responsibleParties == null) {
            this._responsibleParties = new LinkedList<ResponsibleParty>();
        }
        return this._responsibleParties.add(value);
    }

    public boolean removeResponsibleParty(ResponsibleParty item) {
        ResponsibleParty value = (ResponsibleParty)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._responsibleParties != null && this._responsibleParties.remove(value);
    }

    public MarkupMultiline getRemarks() {
        return this._remarks;
    }

    public void setRemarks(MarkupMultiline value) {
        this._remarks = value;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }
}

