/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model;

import gov.nist.secauto.metaschema.core.datatype.adapter.TokenAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValue;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValues;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.Matches;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.ValueConstraints;
import gov.nist.secauto.oscal.lib.model.OscalMetadataModule;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(formalName="Address", description="A postal address for the location.", name="address", moduleClass=OscalMetadataModule.class)
public class Address
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundFlag(formalName="Address Type", description="Indicates the type of address.", name="type", typeAdapter=TokenAdapter.class, valueConstraints=@ValueConstraints(allowedValues={@AllowedValues(level=IConstraint.Level.ERROR, allowOthers=true, values={@AllowedValue(value="home", description="A home address."), @AllowedValue(value="work", description="A work address.")})}))
    private String _type;
    @BoundField(formalName="Address line", description="A single line of an address.", useName="addr-line", maxOccurs=-1, groupAs=@GroupAs(name="addr-lines", inJson=JsonGroupAsBehavior.LIST))
    private List<String> _addrLines;
    @BoundField(formalName="City", description="City, town or geographical region for the mailing address.", useName="city")
    private String _city;
    @BoundField(formalName="State", description="State, province or analogous geographical region for a mailing address.", useName="state")
    private String _state;
    @BoundField(formalName="Postal Code", description="Postal or ZIP code for mailing address.", useName="postal-code")
    private String _postalCode;
    @BoundField(formalName="Country Code", description="The ISO 3166-1 alpha-2 country code for the mailing address.", useName="country", valueConstraints=@ValueConstraints(matches={@Matches(level=IConstraint.Level.ERROR, pattern="[A-Z]{2}")}))
    private String _country;

    public Address() {
        this(null);
    }

    public Address(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public String getType() {
        return this._type;
    }

    public void setType(String value) {
        this._type = value;
    }

    public List<String> getAddrLines() {
        return this._addrLines;
    }

    public void setAddrLines(List<String> value) {
        this._addrLines = value;
    }

    public boolean addAddrLine(String item) {
        String value = (String)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._addrLines == null) {
            this._addrLines = new LinkedList<String>();
        }
        return this._addrLines.add(value);
    }

    public boolean removeAddrLine(String item) {
        String value = (String)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._addrLines != null && this._addrLines.remove(value);
    }

    public String getCity() {
        return this._city;
    }

    public void setCity(String value) {
        this._city = value;
    }

    public String getState() {
        return this._state;
    }

    public void setState(String value) {
        this._state = value;
    }

    public String getPostalCode() {
        return this._postalCode;
    }

    public void setPostalCode(String value) {
        this._postalCode = value;
    }

    public String getCountry() {
        return this._country;
    }

    public void setCountry(String value) {
        this._country = value;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }
}

