/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model;

import gov.nist.secauto.metaschema.core.datatype.adapter.UuidAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLineAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultilineAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.AssemblyConstraints;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.IsUnique;
import gov.nist.secauto.metaschema.databind.model.annotations.KeyField;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.oscal.lib.model.Link;
import gov.nist.secauto.oscal.lib.model.OscalAssessmentCommonModule;
import gov.nist.secauto.oscal.lib.model.Property;
import gov.nist.secauto.oscal.lib.model.ResponsibleParty;
import gov.nist.secauto.oscal.lib.model.SystemComponent;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(formalName="Assessment Assets", description="Identifies the assets used to perform this assessment, such as the assessment team, scanning tools, and assumptions.", name="assessment-assets", moduleClass=OscalAssessmentCommonModule.class, modelConstraints=@AssemblyConstraints(unique={@IsUnique(id="unique-ssp-assessment-assets-component", level=IConstraint.Level.ERROR, target="component", keyFields={@KeyField(target="@uuid")}, remarks="Since multiple assessment `component` entries can be provided, each component must have a unique `uuid`.")}))
public class AssessmentAssets
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundAssembly(formalName="Component", description="A defined component that can be part of an implemented system.", useName="component", remarks="Used to add any components for tools used during the assessment. These are represented here to avoid mixing with system components.\n\nThe technology tools used by the assessor to perform the assessment, such as vulnerability scanners. In the assessment plan these are the intended tools. In the assessment results, these are the actual tools used, including any differences from the assessment plan.", maxOccurs=-1, groupAs=@GroupAs(name="components", inJson=JsonGroupAsBehavior.LIST))
    private List<SystemComponent> _components;
    @BoundAssembly(formalName="Assessment Platform", description="Used to represent the toolset used to perform aspects of the assessment.", useName="assessment-platform", minOccurs=1, maxOccurs=-1, groupAs=@GroupAs(name="assessment-platforms", inJson=JsonGroupAsBehavior.LIST))
    private List<AssessmentPlatform> _assessmentPlatforms;

    public AssessmentAssets() {
        this(null);
    }

    public AssessmentAssets(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public List<SystemComponent> getComponents() {
        return this._components;
    }

    public void setComponents(List<SystemComponent> value) {
        this._components = value;
    }

    public boolean addComponent(SystemComponent item) {
        SystemComponent value = (SystemComponent)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._components == null) {
            this._components = new LinkedList<SystemComponent>();
        }
        return this._components.add(value);
    }

    public boolean removeComponent(SystemComponent item) {
        SystemComponent value = (SystemComponent)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._components != null && this._components.remove(value);
    }

    public List<AssessmentPlatform> getAssessmentPlatforms() {
        return this._assessmentPlatforms;
    }

    public void setAssessmentPlatforms(List<AssessmentPlatform> value) {
        this._assessmentPlatforms = value;
    }

    public boolean addAssessmentPlatform(AssessmentPlatform item) {
        AssessmentPlatform value = (AssessmentPlatform)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._assessmentPlatforms == null) {
            this._assessmentPlatforms = new LinkedList<AssessmentPlatform>();
        }
        return this._assessmentPlatforms.add(value);
    }

    public boolean removeAssessmentPlatform(AssessmentPlatform item) {
        AssessmentPlatform value = (AssessmentPlatform)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._assessmentPlatforms != null && this._assessmentPlatforms.remove(value);
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }

    @MetaschemaAssembly(formalName="Assessment Platform", description="Used to represent the toolset used to perform aspects of the assessment.", name="assessment-platform", moduleClass=OscalAssessmentCommonModule.class)
    public static class AssessmentPlatform
    implements IBoundObject {
        private final IMetaschemaData __metaschemaData;
        @BoundFlag(formalName="Assessment Platform Universally Unique Identifier", description="A [machine-oriented](https://pages.nist.gov/OSCAL/concepts/identifier-use/#machine-oriented), [globally unique](https://pages.nist.gov/OSCAL/concepts/identifier-use/#globally-unique) identifier with [cross-instance](https://pages.nist.gov/OSCAL/concepts/identifier-use/#cross-instance) scope that can be used to reference this assessment platform elsewhere in this or other OSCAL instances. The locally defined *UUID* of the `assessment platform` can be used to reference the data item locally or globally (e.g., in an [imported OSCAL instance](https://pages.nist.gov/OSCAL/concepts/identifier-use/#scope)). This UUID should be assigned [per-subject](https://pages.nist.gov/OSCAL/concepts/identifier-use/#consistency), which means it should be consistently used to identify the same subject across revisions of the document.", name="uuid", required=true, typeAdapter=UuidAdapter.class)
        private UUID _uuid;
        @BoundField(formalName="Assessment Platform Title", description="The title or name for the assessment platform.", useName="title", typeAdapter=MarkupLineAdapter.class)
        private MarkupLine _title;
        @BoundAssembly(formalName="Property", description="An attribute, characteristic, or quality of the containing object expressed as a namespace qualified name/value pair.", useName="prop", maxOccurs=-1, groupAs=@GroupAs(name="props", inJson=JsonGroupAsBehavior.LIST))
        private List<Property> _props;
        @BoundAssembly(formalName="Link", description="A reference to a local or remote resource, that has a specific relation to the containing object.", useName="link", maxOccurs=-1, groupAs=@GroupAs(name="links", inJson=JsonGroupAsBehavior.LIST))
        private List<Link> _links;
        @BoundAssembly(formalName="Uses Component", description="The set of components that are used by the assessment platform.", useName="uses-component", maxOccurs=-1, groupAs=@GroupAs(name="uses-components", inJson=JsonGroupAsBehavior.LIST))
        private List<UsesComponent> _usesComponents;
        @BoundField(formalName="Remarks", description="Additional commentary about the containing object.", useName="remarks", typeAdapter=MarkupMultilineAdapter.class)
        private MarkupMultiline _remarks;

        public AssessmentPlatform() {
            this(null);
        }

        public AssessmentPlatform(IMetaschemaData data) {
            this.__metaschemaData = data;
        }

        public IMetaschemaData getMetaschemaData() {
            return this.__metaschemaData;
        }

        public UUID getUuid() {
            return this._uuid;
        }

        public void setUuid(UUID value) {
            this._uuid = value;
        }

        public MarkupLine getTitle() {
            return this._title;
        }

        public void setTitle(MarkupLine value) {
            this._title = value;
        }

        public List<Property> getProps() {
            return this._props;
        }

        public void setProps(List<Property> value) {
            this._props = value;
        }

        public boolean addProp(Property item) {
            Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._props == null) {
                this._props = new LinkedList<Property>();
            }
            return this._props.add(value);
        }

        public boolean removeProp(Property item) {
            Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._props != null && this._props.remove(value);
        }

        public List<Link> getLinks() {
            return this._links;
        }

        public void setLinks(List<Link> value) {
            this._links = value;
        }

        public boolean addLink(Link item) {
            Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._links == null) {
                this._links = new LinkedList<Link>();
            }
            return this._links.add(value);
        }

        public boolean removeLink(Link item) {
            Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._links != null && this._links.remove(value);
        }

        public List<UsesComponent> getUsesComponents() {
            return this._usesComponents;
        }

        public void setUsesComponents(List<UsesComponent> value) {
            this._usesComponents = value;
        }

        public boolean addUsesComponent(UsesComponent item) {
            UsesComponent value = (UsesComponent)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._usesComponents == null) {
                this._usesComponents = new LinkedList<UsesComponent>();
            }
            return this._usesComponents.add(value);
        }

        public boolean removeUsesComponent(UsesComponent item) {
            UsesComponent value = (UsesComponent)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._usesComponents != null && this._usesComponents.remove(value);
        }

        public MarkupMultiline getRemarks() {
            return this._remarks;
        }

        public void setRemarks(MarkupMultiline value) {
            this._remarks = value;
        }

        public String toString() {
            return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
        }

        @MetaschemaAssembly(formalName="Uses Component", description="The set of components that are used by the assessment platform.", name="uses-component", moduleClass=OscalAssessmentCommonModule.class, modelConstraints=@AssemblyConstraints(unique={@IsUnique(id="unique-ssp-uses-component-responsible-party", level=IConstraint.Level.ERROR, target="responsible-party", keyFields={@KeyField(target="@role-id")}, remarks="Since `responsible-party` associates multiple `party-uuid` entries with a single `role-id`, each role-id must be referenced only once.")}))
        public static class UsesComponent
        implements IBoundObject {
            private final IMetaschemaData __metaschemaData;
            @BoundFlag(formalName="Component Universally Unique Identifier Reference", description="A [machine-oriented](https://pages.nist.gov/OSCAL/concepts/identifier-use/#machine-oriented) identifier reference to a component that is implemented as part of an inventory item.", name="component-uuid", required=true, typeAdapter=UuidAdapter.class)
            private UUID _componentUuid;
            @BoundAssembly(formalName="Property", description="An attribute, characteristic, or quality of the containing object expressed as a namespace qualified name/value pair.", useName="prop", maxOccurs=-1, groupAs=@GroupAs(name="props", inJson=JsonGroupAsBehavior.LIST))
            private List<Property> _props;
            @BoundAssembly(formalName="Link", description="A reference to a local or remote resource, that has a specific relation to the containing object.", useName="link", maxOccurs=-1, groupAs=@GroupAs(name="links", inJson=JsonGroupAsBehavior.LIST))
            private List<Link> _links;
            @BoundAssembly(formalName="Responsible Party", description="A reference to a set of persons and/or organizations that have responsibility for performing the referenced role in the context of the containing object.", useName="responsible-party", maxOccurs=-1, groupAs=@GroupAs(name="responsible-parties", inJson=JsonGroupAsBehavior.LIST))
            private List<ResponsibleParty> _responsibleParties;
            @BoundField(formalName="Remarks", description="Additional commentary about the containing object.", useName="remarks", typeAdapter=MarkupMultilineAdapter.class)
            private MarkupMultiline _remarks;

            public UsesComponent() {
                this(null);
            }

            public UsesComponent(IMetaschemaData data) {
                this.__metaschemaData = data;
            }

            public IMetaschemaData getMetaschemaData() {
                return this.__metaschemaData;
            }

            public UUID getComponentUuid() {
                return this._componentUuid;
            }

            public void setComponentUuid(UUID value) {
                this._componentUuid = value;
            }

            public List<Property> getProps() {
                return this._props;
            }

            public void setProps(List<Property> value) {
                this._props = value;
            }

            public boolean addProp(Property item) {
                Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
                if (this._props == null) {
                    this._props = new LinkedList<Property>();
                }
                return this._props.add(value);
            }

            public boolean removeProp(Property item) {
                Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
                return this._props != null && this._props.remove(value);
            }

            public List<Link> getLinks() {
                return this._links;
            }

            public void setLinks(List<Link> value) {
                this._links = value;
            }

            public boolean addLink(Link item) {
                Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
                if (this._links == null) {
                    this._links = new LinkedList<Link>();
                }
                return this._links.add(value);
            }

            public boolean removeLink(Link item) {
                Link value = (Link)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
                return this._links != null && this._links.remove(value);
            }

            public List<ResponsibleParty> getResponsibleParties() {
                return this._responsibleParties;
            }

            public void setResponsibleParties(List<ResponsibleParty> value) {
                this._responsibleParties = value;
            }

            public boolean addResponsibleParty(ResponsibleParty item) {
                ResponsibleParty value = (ResponsibleParty)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
                if (this._responsibleParties == null) {
                    this._responsibleParties = new LinkedList<ResponsibleParty>();
                }
                return this._responsibleParties.add(value);
            }

            public boolean removeResponsibleParty(ResponsibleParty item) {
                ResponsibleParty value = (ResponsibleParty)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
                return this._responsibleParties != null && this._responsibleParties.remove(value);
            }

            public MarkupMultiline getRemarks() {
                return this._remarks;
            }

            public void setRemarks(MarkupMultiline value) {
                this._remarks = value;
            }

            public String toString() {
                return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
            }
        }
    }
}

