/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.oscal.lib.model;

import gov.nist.secauto.metaschema.core.datatype.adapter.UuidAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultilineAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValue;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValues;
import gov.nist.secauto.metaschema.databind.model.annotations.AssemblyConstraints;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.IsUnique;
import gov.nist.secauto.metaschema.databind.model.annotations.KeyField;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.ValueConstraints;
import gov.nist.secauto.oscal.lib.model.AbstractOscalInstance;
import gov.nist.secauto.oscal.lib.model.Activity;
import gov.nist.secauto.oscal.lib.model.AssessmentAssets;
import gov.nist.secauto.oscal.lib.model.AssessmentPart;
import gov.nist.secauto.oscal.lib.model.AssessmentSubject;
import gov.nist.secauto.oscal.lib.model.BackMatter;
import gov.nist.secauto.oscal.lib.model.ImportSsp;
import gov.nist.secauto.oscal.lib.model.InventoryItem;
import gov.nist.secauto.oscal.lib.model.LocalObjective;
import gov.nist.secauto.oscal.lib.model.Metadata;
import gov.nist.secauto.oscal.lib.model.OscalApModule;
import gov.nist.secauto.oscal.lib.model.ReviewedControls;
import gov.nist.secauto.oscal.lib.model.SystemComponent;
import gov.nist.secauto.oscal.lib.model.SystemUser;
import gov.nist.secauto.oscal.lib.model.Task;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(formalName="Security Assessment Plan (SAP)", description="An assessment plan, such as those provided by a FedRAMP assessor.", name="assessment-plan", moduleClass=OscalApModule.class, rootName="assessment-plan")
public class AssessmentPlan
extends AbstractOscalInstance
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundFlag(formalName="Assessment Plan Universally Unique Identifier", description="A [machine-oriented](https://pages.nist.gov/OSCAL/concepts/identifier-use/#machine-oriented), [globally unique](https://pages.nist.gov/OSCAL/concepts/identifier-use/#globally-unique) identifier with [cross-instance](https://pages.nist.gov/OSCAL/concepts/identifier-use/#cross-instance) scope that can be used to reference this assessment plan in [this or other OSCAL instances](https://pages.nist.gov/OSCAL/concepts/identifier-use/#ap-identifiers). The locally defined *UUID* of the `assessment plan` can be used to reference the data item locally or globally (e.g., in an imported OSCAL instance). This UUID should be assigned [per-subject](https://pages.nist.gov/OSCAL/concepts/identifier-use/#consistency), which means it should be consistently used to identify the same subject across revisions of the document.", name="uuid", required=true, typeAdapter=UuidAdapter.class)
    private UUID _uuid;
    @BoundAssembly(formalName="Document Metadata", description="Provides information about the containing document, and defines concepts that are shared across the document.", useName="metadata", minOccurs=1)
    private Metadata _metadata;
    @BoundAssembly(formalName="Import System Security Plan", description="Used by the assessment plan and POA\\&M to import information about the system.", useName="import-ssp", remarks="Used by the SAP to import information about the system being assessed.", minOccurs=1)
    private ImportSsp _importSsp;
    @BoundAssembly(formalName="Local Definitions", description="Used to define data objects that are used in the assessment plan, that do not appear in the referenced SSP.", useName="local-definitions")
    private LocalDefinitions _localDefinitions;
    @BoundAssembly(formalName="Assessment Plan Terms and Conditions", description="Used to define various terms and conditions under which an assessment, described by the plan, can be performed. Each child part defines a different type of term or condition.", useName="terms-and-conditions")
    private TermsAndConditions _termsAndConditions;
    @BoundAssembly(formalName="Reviewed Controls and Control Objectives", description="Identifies the controls being assessed and their control objectives.", useName="reviewed-controls", minOccurs=1)
    private ReviewedControls _reviewedControls;
    @BoundAssembly(formalName="Subject of Assessment", description="Identifies system elements being assessed, such as components, inventory items, and locations. In the assessment plan, this identifies a planned assessment subject. In the assessment results this is an actual assessment subject, and reflects any changes from the plan. exactly what will be the focus of this assessment. Any subjects not identified in this way are out-of-scope.", useName="assessment-subject", maxOccurs=-1, groupAs=@GroupAs(name="assessment-subjects", inJson=JsonGroupAsBehavior.LIST))
    private List<AssessmentSubject> _assessmentSubjects;
    @BoundAssembly(formalName="Assessment Assets", description="Identifies the assets used to perform this assessment, such as the assessment team, scanning tools, and assumptions.", useName="assessment-assets")
    private AssessmentAssets _assessmentAssets;
    @BoundAssembly(formalName="Task", description="Represents a scheduled event or milestone, which may be associated with a series of assessment actions.", useName="task", maxOccurs=-1, groupAs=@GroupAs(name="tasks", inJson=JsonGroupAsBehavior.LIST))
    private List<Task> _tasks;
    @BoundAssembly(formalName="Back matter", description="A collection of resources that may be referenced from within the OSCAL document instance.", useName="back-matter")
    private BackMatter _backMatter;

    public AssessmentPlan() {
        this(null);
    }

    public AssessmentPlan(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    @Override
    public UUID getUuid() {
        return this._uuid;
    }

    public void setUuid(UUID value) {
        this._uuid = value;
    }

    @Override
    public Metadata getMetadata() {
        return this._metadata;
    }

    public void setMetadata(Metadata value) {
        this._metadata = value;
    }

    public ImportSsp getImportSsp() {
        return this._importSsp;
    }

    public void setImportSsp(ImportSsp value) {
        this._importSsp = value;
    }

    public LocalDefinitions getLocalDefinitions() {
        return this._localDefinitions;
    }

    public void setLocalDefinitions(LocalDefinitions value) {
        this._localDefinitions = value;
    }

    public TermsAndConditions getTermsAndConditions() {
        return this._termsAndConditions;
    }

    public void setTermsAndConditions(TermsAndConditions value) {
        this._termsAndConditions = value;
    }

    public ReviewedControls getReviewedControls() {
        return this._reviewedControls;
    }

    public void setReviewedControls(ReviewedControls value) {
        this._reviewedControls = value;
    }

    public List<AssessmentSubject> getAssessmentSubjects() {
        return this._assessmentSubjects;
    }

    public void setAssessmentSubjects(List<AssessmentSubject> value) {
        this._assessmentSubjects = value;
    }

    public boolean addAssessmentSubject(AssessmentSubject item) {
        AssessmentSubject value = (AssessmentSubject)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._assessmentSubjects == null) {
            this._assessmentSubjects = new LinkedList<AssessmentSubject>();
        }
        return this._assessmentSubjects.add(value);
    }

    public boolean removeAssessmentSubject(AssessmentSubject item) {
        AssessmentSubject value = (AssessmentSubject)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._assessmentSubjects != null && this._assessmentSubjects.remove(value);
    }

    public AssessmentAssets getAssessmentAssets() {
        return this._assessmentAssets;
    }

    public void setAssessmentAssets(AssessmentAssets value) {
        this._assessmentAssets = value;
    }

    public List<Task> getTasks() {
        return this._tasks;
    }

    public void setTasks(List<Task> value) {
        this._tasks = value;
    }

    public boolean addTask(Task item) {
        Task value = (Task)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._tasks == null) {
            this._tasks = new LinkedList<Task>();
        }
        return this._tasks.add(value);
    }

    public boolean removeTask(Task item) {
        Task value = (Task)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._tasks != null && this._tasks.remove(value);
    }

    @Override
    public BackMatter getBackMatter() {
        return this._backMatter;
    }

    public void setBackMatter(BackMatter value) {
        this._backMatter = value;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }

    @MetaschemaAssembly(formalName="Local Definitions", description="Used to define data objects that are used in the assessment plan, that do not appear in the referenced SSP.", name="local-definitions", moduleClass=OscalApModule.class, modelConstraints=@AssemblyConstraints(unique={@IsUnique(id="unique-ap-local-definitions-component", level=IConstraint.Level.ERROR, target="component", keyFields={@KeyField(target="@uuid")}, remarks="Since multiple `component` entries can be provided, each component must have a unique `uuid`."), @IsUnique(id="unique-ap-local-definitions-user", level=IConstraint.Level.ERROR, target="user", keyFields={@KeyField(target="@uuid")}, remarks="A given `uuid` must be assigned only once to a user.")}))
    public static class LocalDefinitions
    implements IBoundObject {
        private final IMetaschemaData __metaschemaData;
        @BoundAssembly(formalName="Component", description="A defined component that can be part of an implemented system.", useName="component", remarks="Used to add any components, not defined via the System Security Plan (AR-\\>AP-\\>SSP)", maxOccurs=-1, groupAs=@GroupAs(name="components", inJson=JsonGroupAsBehavior.LIST))
        private List<SystemComponent> _components;
        @BoundAssembly(formalName="Inventory Item", description="A single managed inventory item within the system.", useName="inventory-item", remarks="Used to add any inventory-items, not defined via the System Security Plan (AR-\\>AP-\\>SSP)", maxOccurs=-1, groupAs=@GroupAs(name="inventory-items", inJson=JsonGroupAsBehavior.LIST))
        private List<InventoryItem> _inventoryItems;
        @BoundAssembly(formalName="System User", description="A type of user that interacts with the system based on an associated role.", useName="user", remarks="Used to add any users, not defined via the System Security Plan (AR-\\>AP-\\>SSP)", maxOccurs=-1, groupAs=@GroupAs(name="users", inJson=JsonGroupAsBehavior.LIST))
        private List<SystemUser> _users;
        @BoundAssembly(formalName="Assessment-Specific Control Objective", description="A local definition of a control objective for this assessment. Uses catalog syntax for control objective and assessment actions.", useName="objectives-and-methods", maxOccurs=-1, groupAs=@GroupAs(name="objectives-and-methods", inJson=JsonGroupAsBehavior.LIST))
        private List<LocalObjective> _objectivesAndMethods;
        @BoundAssembly(formalName="Activity", description="Identifies an assessment or related process that can be performed. In the assessment plan, this is an intended activity which may be associated with an assessment task. In the assessment results, this an activity that was actually performed as part of an assessment.", useName="activity", maxOccurs=-1, groupAs=@GroupAs(name="activities", inJson=JsonGroupAsBehavior.LIST))
        private List<Activity> _activities;
        @BoundField(formalName="Remarks", description="Additional commentary about the containing object.", useName="remarks", typeAdapter=MarkupMultilineAdapter.class)
        private MarkupMultiline _remarks;

        public LocalDefinitions() {
            this(null);
        }

        public LocalDefinitions(IMetaschemaData data) {
            this.__metaschemaData = data;
        }

        public IMetaschemaData getMetaschemaData() {
            return this.__metaschemaData;
        }

        public List<SystemComponent> getComponents() {
            return this._components;
        }

        public void setComponents(List<SystemComponent> value) {
            this._components = value;
        }

        public boolean addComponent(SystemComponent item) {
            SystemComponent value = (SystemComponent)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._components == null) {
                this._components = new LinkedList<SystemComponent>();
            }
            return this._components.add(value);
        }

        public boolean removeComponent(SystemComponent item) {
            SystemComponent value = (SystemComponent)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._components != null && this._components.remove(value);
        }

        public List<InventoryItem> getInventoryItems() {
            return this._inventoryItems;
        }

        public void setInventoryItems(List<InventoryItem> value) {
            this._inventoryItems = value;
        }

        public boolean addInventoryItem(InventoryItem item) {
            InventoryItem value = (InventoryItem)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._inventoryItems == null) {
                this._inventoryItems = new LinkedList<InventoryItem>();
            }
            return this._inventoryItems.add(value);
        }

        public boolean removeInventoryItem(InventoryItem item) {
            InventoryItem value = (InventoryItem)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._inventoryItems != null && this._inventoryItems.remove(value);
        }

        public List<SystemUser> getUsers() {
            return this._users;
        }

        public void setUsers(List<SystemUser> value) {
            this._users = value;
        }

        public boolean addUser(SystemUser item) {
            SystemUser value = (SystemUser)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._users == null) {
                this._users = new LinkedList<SystemUser>();
            }
            return this._users.add(value);
        }

        public boolean removeUser(SystemUser item) {
            SystemUser value = (SystemUser)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._users != null && this._users.remove(value);
        }

        public List<LocalObjective> getObjectivesAndMethods() {
            return this._objectivesAndMethods;
        }

        public void setObjectivesAndMethods(List<LocalObjective> value) {
            this._objectivesAndMethods = value;
        }

        public boolean addObjectivesAndMethods(LocalObjective item) {
            LocalObjective value = (LocalObjective)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._objectivesAndMethods == null) {
                this._objectivesAndMethods = new LinkedList<LocalObjective>();
            }
            return this._objectivesAndMethods.add(value);
        }

        public boolean removeObjectivesAndMethods(LocalObjective item) {
            LocalObjective value = (LocalObjective)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._objectivesAndMethods != null && this._objectivesAndMethods.remove(value);
        }

        public List<Activity> getActivities() {
            return this._activities;
        }

        public void setActivities(List<Activity> value) {
            this._activities = value;
        }

        public boolean addActivity(Activity item) {
            Activity value = (Activity)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._activities == null) {
                this._activities = new LinkedList<Activity>();
            }
            return this._activities.add(value);
        }

        public boolean removeActivity(Activity item) {
            Activity value = (Activity)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._activities != null && this._activities.remove(value);
        }

        public MarkupMultiline getRemarks() {
            return this._remarks;
        }

        public void setRemarks(MarkupMultiline value) {
            this._remarks = value;
        }

        public String toString() {
            return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
        }
    }

    @MetaschemaAssembly(formalName="Assessment Plan Terms and Conditions", description="Used to define various terms and conditions under which an assessment, described by the plan, can be performed. Each child part defines a different type of term or condition.", name="terms-and-conditions", moduleClass=OscalApModule.class, valueConstraints=@ValueConstraints(allowedValues={@AllowedValues(level=IConstraint.Level.ERROR, target="part[has-oscal-namespace('http://csrc.nist.gov/ns/oscal')]/@name", values={@AllowedValue(value="rules-of-engagement", description="Defines the circumstances, conditions, degree, and manner in which the use of cyber-attack techniques or actions may be applied to the assessment."), @AllowedValue(value="disclosures", description="Any information the assessor should make known to the system owner or authorizing official. Has child 'item' parts for each individual disclosure."), @AllowedValue(value="assessment-inclusions", description="Defines any assessment activities which the system owner or authorizing official wishes to ensure are performed as part of the assessment."), @AllowedValue(value="assessment-exclusions", description="Defines any assessment activities which the system owner or authorizing official explicitly prohibits from being performed as part of the assessment."), @AllowedValue(value="results-delivery", description="Defines conditions related to the delivery of the assessment results, such as when to deliver, how, and to whom."), @AllowedValue(value="assumptions", description="Defines any supposition made by the assessor. Has child 'item' parts for each assumption."), @AllowedValue(value="methodology", description="An explanation of practices, procedures, and rules used in the course of the assessment.")})}))
    public static class TermsAndConditions
    implements IBoundObject {
        private final IMetaschemaData __metaschemaData;
        @BoundAssembly(formalName="Assessment Part", description="A partition of an assessment plan or results or a child of another part.", useName="part", maxOccurs=-1, groupAs=@GroupAs(name="parts", inJson=JsonGroupAsBehavior.LIST))
        private List<AssessmentPart> _parts;

        public TermsAndConditions() {
            this(null);
        }

        public TermsAndConditions(IMetaschemaData data) {
            this.__metaschemaData = data;
        }

        public IMetaschemaData getMetaschemaData() {
            return this.__metaschemaData;
        }

        public List<AssessmentPart> getParts() {
            return this._parts;
        }

        public void setParts(List<AssessmentPart> value) {
            this._parts = value;
        }

        public boolean addPart(AssessmentPart item) {
            AssessmentPart value = (AssessmentPart)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            if (this._parts == null) {
                this._parts = new LinkedList<AssessmentPart>();
            }
            return this._parts.add(value);
        }

        public boolean removePart(AssessmentPart item) {
            AssessmentPart value = (AssessmentPart)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
            return this._parts != null && this._parts.remove(value);
        }

        public String toString() {
            return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
        }
    }
}

